/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.client;

import dev.xkmc.l2core.init.L2CoreConfig;
import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.l2weaponry.content.client.CommonDecoUtil;
import dev.xkmc.l2weaponry.content.item.base.IAttackBlockingWeapon;
import dev.xkmc.l2weaponry.content.item.base.IStackableWeapon;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.IItemDecorator;

public class ClawItemDecorationRenderer
implements IItemDecorator {
    public boolean render(GuiGraphics g, Font font, ItemStack stack, int x, int y) {
        IAttackBlockingWeapon block;
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null) {
            return false;
        }
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        if (main != stack && off != stack) {
            return false;
        }
        if (main != stack && off.getItem() != main.getItem()) {
            return false;
        }
        Item item = stack.getItem();
        if (!(item instanceof IStackableWeapon)) {
            return false;
        }
        IStackableWeapon claw = (IStackableWeapon)item;
        if (claw.getMaxStack(stack, null) <= 0) {
            return false;
        }
        long last = IStackableWeapon.getLastTime(main);
        int timeout = (Integer)LWConfig.SERVER.claw_timeout.get();
        float time = (float)(player.level().getGameTime() - last) + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        if (time > (float)timeout) {
            return false;
        }
        g.pose().pushPose();
        int height = (Integer)L2CoreConfig.CLIENT.overlayZVal.get();
        g.pose().translate(0.0f, 0.0f, (float)height);
        float defenseLost = Mth.clamp((float)time, (float)0.0f, (float)timeout) / (float)timeout;
        float w = 13.0f * (1.0f - defenseLost);
        int col = -1;
        if (claw instanceof IAttackBlockingWeapon && time <= (block = (IAttackBlockingWeapon)claw).getBlockTime((LivingEntity)player)) {
            col = -16711681;
        }
        CommonDecoUtil.fillRect(g, x + 2, y + 14, w, 1.0f, col);
        CommonDecoUtil.fillRect(g, (float)(x + 2) + w, y + 14, 13.0f - w, 1.0f, -16777216);
        int stored_hit = IStackableWeapon.getHitCount(main);
        int max_hit = claw.getMaxStack(main, (LivingEntity)Proxy.getClientPlayer());
        int hit = Math.min(max_hit, stored_hit);
        String s = "" + hit;
        col = hit < max_hit ? 0xFF7FFF : 0xFF7F7F;
        g.drawString(font, s, x + 17 - font.width(s), y + 9, col);
        g.pose().popPose();
        return true;
    }
}

