/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.capability;

import dev.xkmc.l2core.events.SchedulerHandler;
import dev.xkmc.l2weaponry.content.capability.IShieldData;
import dev.xkmc.l2weaponry.content.item.base.BaseShieldItem;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.ItemStack;

public class MobShieldGoal
extends Goal
implements IShieldData {
    private final Mob mob;
    private double shieldDefense;

    public static MobShieldGoal getShieldGoal(Mob mob) {
        Optional<WrappedGoal> opt = mob.goalSelector.getAvailableGoals().stream().filter(e -> e.getGoal() instanceof MobShieldGoal).findFirst();
        if (opt.isPresent()) {
            return (MobShieldGoal)opt.get().getGoal();
        }
        MobShieldGoal ans = new MobShieldGoal(mob);
        SchedulerHandler.schedule(() -> mob.goalSelector.addGoal(0, (Goal)ans));
        return ans;
    }

    private MobShieldGoal(Mob mob) {
        this.mob = mob;
    }

    public boolean onBlock(ItemStack stack, BaseShieldItem item, boolean shouldDisable, LivingEntity target) {
        double strength = item.reflectImpl(stack, this.mob.level().damageSources().mobAttack((LivingEntity)this.mob), this.mob.getAttributeValue(Attributes.ATTACK_DAMAGE), this, target);
        target.knockback(strength, this.mob.getX() - target.getX(), this.mob.getZ() - target.getZ());
        if (!shouldDisable && !item.lightWeight(stack)) {
            return false;
        }
        int cd = item.damageShieldImpl((LivingEntity)this.mob, this, stack, shouldDisable ? 1.0 : -1.0);
        return cd > 0;
    }

    public void onShieldDamage(ItemStack stack, BaseShieldItem item, double damage) {
        LWItems.BLOCKED_DAMAGE.set(stack, (Object)((int)damage));
    }

    public boolean canUse() {
        return this.shieldDefense > 0.0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        this.shieldDefense = Math.max(0.0, this.shieldDefense - 0.01);
    }

    @Override
    public double getShieldDefense() {
        return this.shieldDefense;
    }

    @Override
    public void setShieldDefense(double i) {
        this.shieldDefense = i;
    }

    @Override
    public boolean canReflect() {
        return this.mob.getAttribute(LWItems.REFLECT_TIME.holder()) != null && this.mob.getAttributeValue(LWItems.REFLECT_TIME.holder()) > 0.0;
    }

    @Override
    public double popRetain() {
        return 0.0;
    }

    @Override
    public int getReflectTimer() {
        return this.shieldDefense == 0.0 && this.canReflect() ? 1 : 0;
    }
}

