/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.capability;

import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2core.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.l2weaponry.content.capability.IShieldData;
import dev.xkmc.l2weaponry.content.item.base.BaseShieldItem;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.registrate.LWEntities;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

@SerialClass
public class LWPlayerData
extends PlayerCapabilityTemplate<LWPlayerData> {
    @SerialField
    private double shieldDefense = 0.0;
    @SerialField
    private int reflectTimer = 0;
    private double shieldRetain = 0.0;

    public static LWPlayerData get(Player player) {
        return (LWPlayerData)((PlayerCapabilityHolder)LWEntities.PLAYER.type()).getOrCreate((IAttachmentHolder)player);
    }

    public static IShieldData asData(Player player) {
        return new Shield(player, LWPlayerData.get(player));
    }

    public void setShieldDefense(Player player, double shieldDefense) {
        this.shieldDefense = shieldDefense;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ((PlayerCapabilityHolder)LWEntities.PLAYER.type()).network.toClient(sp);
        }
    }

    public double getRecoverRate(Player player) {
        ItemStack stack = player.getUseItem();
        double recover = 0.01;
        Item item = stack.getItem();
        if (item instanceof BaseShieldItem) {
            BaseShieldItem shield = (BaseShieldItem)item;
            recover *= shield.getDefenseRecover(stack);
        }
        return recover;
    }

    public void tick(Player player) {
        double recover = this.getRecoverRate(player);
        if (this.shieldDefense > 0.0) {
            this.shieldDefense -= recover;
            if (this.shieldDefense < 0.0) {
                this.shieldDefense = 0.0;
            }
        }
        if (this.reflectTimer > 0) {
            --this.reflectTimer;
            if (this.reflectTimer == 0) {
                this.shieldRetain = 0.0;
            }
        }
    }

    public boolean canReflect(Player player) {
        return !player.isShiftKeyDown() && player.getAttributeValue(LWItems.REFLECT_TIME.holder()) > 0.0;
    }

    public void startReflectTimer(Player player) {
        if (!this.canReflect(player) || this.shieldDefense > 0.0) {
            return;
        }
        this.shieldDefense += ((Double)LWConfig.SERVER.reflectCost.get()).doubleValue();
        this.shieldRetain = this.shieldDefense * player.getAttributeValue(LWItems.SHIELD_DEFENSE.holder());
        this.reflectTimer = (int)player.getAttributeValue(LWItems.REFLECT_TIME.holder());
    }

    public void clearReflectTimer() {
        this.reflectTimer = 0;
        this.shieldRetain = 0.0;
    }

    public double popRetain() {
        double ans = this.shieldRetain;
        this.shieldRetain = 0.0;
        this.reflectTimer = 0;
        return ans;
    }

    private record Shield(Player player, LWPlayerData data) implements IShieldData
    {
        @Override
        public double getShieldDefense() {
            return this.data.shieldDefense;
        }

        @Override
        public void setShieldDefense(double i) {
            this.data.setShieldDefense(this.player, i);
        }

        @Override
        public int getReflectTimer() {
            return this.data.reflectTimer;
        }

        @Override
        public boolean canReflect() {
            return this.data.canReflect(this.player);
        }

        @Override
        public double popRetain() {
            return this.data.popRetain();
        }
    }
}

