/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.twilightforest;

import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.l2core.util.MathHelper;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatToolType;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.compat.ModMats;
import dev.xkmc.l2weaponry.compat.twilightforest.FieryTool;
import dev.xkmc.l2weaponry.compat.twilightforest.IronwoodTool;
import dev.xkmc.l2weaponry.compat.twilightforest.KnightmetalTool;
import dev.xkmc.l2weaponry.compat.twilightforest.SteeleafTool;
import dev.xkmc.l2weaponry.compat.twilightforest.TFCompat;
import dev.xkmc.l2weaponry.init.materials.ILWToolMats;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import dev.xkmc.l2weaponry.init.materials.LWToolTypes;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.util.TFToolMaterials;

public enum TFToolMats implements ILWToolMats
{
    IRONWOOD(new ModMats(TFToolMaterials.IRONWOOD, new IronwoodTool()), false, (Supplier<Item>)TFItems.IRONWOOD_INGOT, (Supplier<Block>)TFBlocks.IRONWOOD_BLOCK),
    STEELEAF(new ModMats(TFToolMaterials.STEELEAF, new SteeleafTool()), false, (Supplier<Item>)TFItems.STEELEAF_INGOT, (Supplier<Block>)TFBlocks.STEELEAF_BLOCK),
    KNIGHTMETAL(new ModMats(TFToolMaterials.KNIGHTMETAL, new KnightmetalTool()), false, (Supplier<Item>)TFItems.KNIGHTMETAL_INGOT, (Supplier<Block>)TFBlocks.KNIGHTMETAL_BLOCK),
    FIERY(new ModMats(TFToolMaterials.FIERY, new FieryTool()), true, (Supplier<Item>)TFItems.FIERY_INGOT, (Supplier<Block>)TFBlocks.FIERY_BLOCK);

    private final IMatToolType type;
    private final boolean fireRes;
    private final Supplier<Item> ingot;
    private final Supplier<Block> block;

    private TFToolMats(IMatToolType type, boolean fireRes, Supplier<Item> ingot, Supplier<Block> block) {
        this.type = type;
        this.fireRes = fireRes;
        this.ingot = ingot;
        this.block = block;
    }

    @Override
    public IMatToolType type() {
        return this.type;
    }

    @Override
    public boolean fireRes() {
        return this.fireRes;
    }

    @Override
    public Item getTool(LWToolTypes type) {
        return (Item)TFCompat.ITEMS[this.ordinal()][type.ordinal()].get();
    }

    @Override
    public Item getIngot() {
        return this.ingot.get();
    }

    @Override
    public Item getBlock() {
        return this.block.get().asItem();
    }

    @Override
    public Item getStick() {
        return this == FIERY ? Items.BLAZE_ROD : (Item)LWItems.HANDLE.get();
    }

    @Override
    public void addEnchants(HolderLookup.Provider pvd, List<LWToolTypes.DefaultEnch> list, LWToolTypes type) {
        ExtraToolConfig extraToolConfig = this.type.getExtraToolConfig();
        if (extraToolConfig instanceof LWExtraConfig) {
            LWExtraConfig lw = (LWExtraConfig)extraToolConfig;
            lw.addEnchants(list, type, this.getTool(type));
        }
    }

    @Override
    public String englishName() {
        return this == KNIGHTMETAL ? "knightly" : this.name();
    }

    @Override
    public boolean emissive() {
        return this == FIERY;
    }

    @Override
    public RecipeOutput getProvider(RegistrateRecipeProvider pvd, ICondition ... cond) {
        return ILWToolMats.super.getProvider(pvd, (ICondition[])MathHelper.merge((Object[])cond, (Object[])new ICondition[]{new ModLoadedCondition("twilightforest")}));
    }

    @Override
    public boolean isOptional() {
        return true;
    }
}

