/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.twilightforest;

import dev.xkmc.l2complements.content.effect.StackingEffect;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.item.base.BaseShieldItem;
import dev.xkmc.l2weaponry.content.item.base.GenericWeaponItem;
import dev.xkmc.l2weaponry.content.item.base.LWTieredItem;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.data.LangData;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import dev.xkmc.l2weaponry.init.materials.LWToolTypes;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public class SteeleafTool
extends ExtraToolConfig
implements LWExtraConfig {
    @Override
    public void addEnchants(List<LWToolTypes.DefaultEnch> list, LWToolTypes type, Item tool) {
        LWTieredItem weapon;
        if (tool instanceof LWTieredItem && (weapon = (LWTieredItem)tool).isSharp()) {
            list.add(new LWToolTypes.DefaultEnch((ResourceKey<Enchantment>)Enchantments.SHARPNESS, 2));
        }
        if (tool instanceof GenericWeaponItem) {
            list.add(new LWToolTypes.DefaultEnch((ResourceKey<Enchantment>)Enchantments.LOOTING, 2));
        }
    }

    private boolean canTrigger(LivingEntity target) {
        return target.getAttribute(Attributes.ARMOR) == null || target.getAttributeValue(Attributes.ARMOR) == 0.0;
    }

    private void addEffect(LivingEntity user, LivingEntity target) {
        if (this.canTrigger(target)) {
            double chance = (Double)LWConfig.SERVER.steeleafChance.get();
            if (user.getRandom().nextDouble() < chance) {
                StackingEffect.addTo((Holder)LCEffects.BLEED, (LivingEntity)target, (int)100, (int)4, (Entity)user);
            }
        }
    }

    @Override
    public void onShieldBlock(ItemStack stack, LivingEntity user, LivingEntity entity) {
        this.addEffect(user, entity);
    }

    @Override
    public double onShieldReflect(ItemStack stack, LivingEntity user, LivingEntity entity, double original, double reflect) {
        return reflect + original * (Double)LWConfig.SERVER.steeleafReflect.get();
    }

    public void onDamage(DamageData.Offence cache, ItemStack stack) {
        LivingEntity target = cache.getTarget();
        if (this.canTrigger(target)) {
            ResourceLocation id = ((ResourceKey)stack.getItemHolder().unwrapKey().orElseThrow()).location();
            double bonus = (Double)LWConfig.SERVER.steeleafBonus.get();
            cache.addHurtModifier(DamageModifier.multBase((float)((float)bonus), (ResourceLocation)id));
            if (cache.getAttacker() != null) {
                this.addEffect(cache.getAttacker(), target);
            }
        }
    }

    public void addTooltip(ItemStack stack, List<Component> list) {
        double bonus = (Double)LWConfig.SERVER.steeleafBonus.get();
        double chance = (Double)LWConfig.SERVER.steeleafChance.get();
        list.add((Component)LangData.MATS_STEELEAF.get((int)Math.round(bonus * 100.0), (int)Math.round(chance * 100.0)));
        if (stack.getItem() instanceof BaseShieldItem) {
            double reflect = (Double)LWConfig.SERVER.steeleafReflect.get();
            list.add((Component)LangData.MATS_REFLECT.get((int)Math.round(reflect * 100.0)));
        }
    }
}

