/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.dragons;

import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.l2core.serial.recipe.ConditionalRecipeWrapper;
import dev.xkmc.l2core.util.MathHelper;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatToolType;
import dev.xkmc.l2weaponry.compat.ModMats;
import dev.xkmc.l2weaponry.compat.dragons.DragonCompat;
import dev.xkmc.l2weaponry.compat.dragons.FireDragonBoneTool;
import dev.xkmc.l2weaponry.compat.dragons.IAFProxy;
import dev.xkmc.l2weaponry.compat.dragons.IceDragonBoneTool;
import dev.xkmc.l2weaponry.compat.dragons.LightningDragonBoneTool;
import dev.xkmc.l2weaponry.init.materials.ILWToolMats;
import dev.xkmc.l2weaponry.init.materials.LWToolTypes;
import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public enum DragonToolMats implements ILWToolMats
{
    ICE_DRAGONSTEEL(new ModMats(IAFProxy.get().tierIce(), new IceDragonBoneTool()), true, IAFProxy.get().ingotIceSteel(), IAFProxy.get().blockIceSteel()),
    FIRE_DRAGONSTEEL(new ModMats(IAFProxy.get().tierFire(), new FireDragonBoneTool()), true, IAFProxy.get().ingotFireSteel(), IAFProxy.get().blockFireSteel()),
    LIGHTNING_DRAGONSTEEL(new ModMats(IAFProxy.get().tierLightning(), new LightningDragonBoneTool()), true, IAFProxy.get().ingotLightningSteel(), IAFProxy.get().blockLightningSteel());

    private final IMatToolType type;
    private final boolean fireRes;
    private final Supplier<Item> ingot;
    private final Supplier<Block> block;

    private DragonToolMats(IMatToolType type, boolean fireRes, Supplier<Item> ingot, Supplier<Block> block) {
        this.type = type;
        this.fireRes = fireRes;
        this.ingot = ingot;
        this.block = block;
    }

    @Override
    public IMatToolType type() {
        return this.type;
    }

    @Override
    public boolean fireRes() {
        return this.fireRes;
    }

    @Override
    public Item getTool(LWToolTypes type) {
        return (Item)DragonCompat.ITEMS[this.ordinal()][type.ordinal()].get();
    }

    @Override
    public Item getIngot() {
        return this.ingot.get();
    }

    @Override
    public Item getBlock() {
        return this.block.get().asItem();
    }

    @Override
    public Item getStick() {
        return IAFProxy.get().witherBone();
    }

    @Override
    public RecipeOutput getProvider(RegistrateRecipeProvider pvd, ICondition ... cond) {
        return ConditionalRecipeWrapper.of((RecipeOutput)pvd, (ICondition[])((ICondition[])MathHelper.merge((Object[])cond, (Object[])new ICondition[]{new ModLoadedCondition(IAFProxy.get().modid())})));
    }

    @Override
    public boolean isOptional() {
        return true;
    }
}

