/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.cataclysm;

import dev.xkmc.l2core.events.SchedulerHandler;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2library.content.explosion.BaseExplosion;
import dev.xkmc.l2library.content.explosion.BaseExplosionContext;
import dev.xkmc.l2library.content.explosion.ExplosionHandler;
import dev.xkmc.l2library.content.explosion.ModExplosionContext;
import dev.xkmc.l2library.content.explosion.ParticleExplosionContext;
import dev.xkmc.l2library.content.explosion.VanillaExplosionContext;
import dev.xkmc.l2weaponry.compat.cataclysm.ToolTicker;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import dev.xkmc.l2weaponry.content.item.base.GenericWeaponItem;
import dev.xkmc.l2weaponry.content.item.base.IExplosionSource;
import dev.xkmc.l2weaponry.content.item.types.BattleAxeItem;
import dev.xkmc.l2weaponry.content.item.types.HammerItem;
import dev.xkmc.l2weaponry.content.item.types.JavelinItem;
import dev.xkmc.l2weaponry.content.item.types.ScytheItem;
import dev.xkmc.l2weaponry.content.item.types.ThrowingAxeItem;
import dev.xkmc.l2weaponry.init.data.LangData;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WitheriteTool
extends ExtraToolConfig
implements LWExtraConfig {
    @Override
    public void onDamageFinal(DamageData.DefenceMax data, LivingEntity attacker, ItemStack stack) {
        int radius;
        Item item;
        if ((double)data.getStrength() < 0.95) {
            return;
        }
        int vis = 1;
        if (!data.getSource().is(L2DamageTypes.DIRECT)) {
            if (!(data.getSource().getDirectEntity() instanceof BaseThrownWeaponEntity)) {
                return;
            }
            vis = 2;
        }
        if (!((item = stack.getItem()) instanceof GenericWeaponItem)) {
            return;
        }
        GenericWeaponItem w = (GenericWeaponItem)item;
        GenericWeaponItem genericWeaponItem = w;
        Objects.requireNonNull(genericWeaponItem);
        GenericWeaponItem genericWeaponItem2 = genericWeaponItem;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BattleAxeItem.class, HammerItem.class, ScytheItem.class, JavelinItem.class, ThrowingAxeItem.class}, (Object)genericWeaponItem2, n)) {
            case 0: {
                BattleAxeItem ignored = (BattleAxeItem)genericWeaponItem2;
                int n2 = 3;
                break;
            }
            case 1: {
                HammerItem ignored = (HammerItem)genericWeaponItem2;
                int n2 = 3;
                break;
            }
            case 2: {
                ScytheItem ignored = (ScytheItem)genericWeaponItem2;
                int n2 = 2;
                break;
            }
            case 3: {
                JavelinItem ignored = (JavelinItem)genericWeaponItem2;
                int n2 = 2;
                break;
            }
            case 4: {
                ThrowingAxeItem ignored = (ThrowingAxeItem)genericWeaponItem2;
                int n2 = 2;
                break;
            }
            default: {
                int n2 = radius = 1;
            }
        }
        if (!(attacker.onGround() && w.canSweep() || radius < vis)) {
            vis = radius;
        }
        LivingEntity target = data.getTarget();
        Vec3 pos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.sendParticles((ParticleOptions)DustParticleOptions.REDSTONE, pos.x, pos.y, pos.z, radius * 5, 0.0, 0.0, 0.0, 0.0);
        }
        int visual = vis;
        SchedulerHandler.schedulePersistent(new ToolTicker(10, () -> this.makeExplosion(attacker, target, pos, radius, visual, stack))::tick);
    }

    public void addTooltip(ItemStack stack, List<Component> list) {
        list.add((Component)LangData.MATS_WITHERITE.get(new Object[0]));
    }

    private void makeExplosion(LivingEntity attacker, LivingEntity target, Vec3 pos, int radius, int visual, ItemStack stack) {
        BaseExplosionContext base = new BaseExplosionContext(target.level(), pos.x(), pos.y(), pos.z(), (float)radius);
        Explosion.BlockInteraction type = Explosion.BlockInteraction.KEEP;
        VanillaExplosionContext mc = new VanillaExplosionContext(null, null, null, false, type);
        ModExplosionContext mod = entity -> this.onExplosionHurt(attacker, target, entity, stack);
        ExplosionHandler.explode((BaseExplosion)new BaseExplosion(base, mc, mod, ParticleExplosionContext.of((float)visual)));
    }

    private boolean onExplosionHurt(LivingEntity attacker, LivingEntity target, Entity entity, ItemStack stack) {
        Item item;
        boolean ans = this.shouldExplosionHurt(attacker, target, entity);
        if (ans && (item = stack.getItem()) instanceof IExplosionSource) {
            IExplosionSource s = (IExplosionSource)item;
            s.onAffecting(attacker, entity, stack);
        }
        return ans;
    }

    private boolean shouldExplosionHurt(LivingEntity attacker, LivingEntity target, Entity entity) {
        if (entity == attacker || entity.isAlliedTo((Entity)attacker) || attacker.isAlliedTo(entity)) {
            return false;
        }
        if (entity == target) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            Mob mob;
            LivingEntity le = (LivingEntity)entity;
            if (le.getLastHurtByMob() == attacker) {
                return true;
            }
            if (le instanceof Mob && (mob = (Mob)le).getTarget() == attacker) {
                return true;
            }
        }
        return false;
    }
}

