/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.cataclysm;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.compat.cataclysm.CataclysmProxy;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import dev.xkmc.l2weaponry.content.item.base.IStackableWeapon;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.content.item.types.ScytheItem;
import dev.xkmc.l2weaponry.init.data.LangData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class SoulHarvester
extends ScytheItem
implements LegendaryWeapon {
    public SoulHarvester(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config);
    }

    @Override
    public void onDamageFinal(DamageData.DefenceMax data, LivingEntity le) {
        Item item;
        if ((double)data.getStrength() < 0.95) {
            return;
        }
        LivingEntity attacker = data.getAttacker();
        if (attacker == null) {
            return;
        }
        float factor = 1.0f;
        if (data.getSource().getDirectEntity() instanceof BaseThrownWeaponEntity) {
            factor = 2.0f;
        } else if (attacker instanceof Player) {
            Player player = (Player)attacker;
            float speed = (float)player.getAttributeValue(Attributes.ATTACK_SPEED);
            factor = 1.0f / Math.clamp(speed, 0.5f, 2.0f);
        }
        ItemStack stack = data.getWeapon();
        int count = IStackableWeapon.getHitCount(stack);
        if (count > 0 && (item = stack.getItem()) instanceof IStackableWeapon) {
            IStackableWeapon item2 = (IStackableWeapon)item;
            int max = item2.getMaxStack(stack, attacker);
            factor *= 1.0f + 0.2f * (float)Mth.clamp((int)count, (int)0, (int)max);
        }
        CataclysmProxy.stackBlazingBrand(attacker, data.getTarget(), factor);
    }

    @Override
    protected int getMaxStackIntrinsic(ItemStack stack) {
        return 59;
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pLevel, list, pIsAdvanced);
        list.add((Component)LangData.MATS_IGNITIUM.get(new Object[0]));
    }
}

