/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.cataclysm;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.compat.cataclysm.CataclysmProxy;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import dev.xkmc.l2weaponry.content.item.base.BaseThrowableWeaponItem;
import dev.xkmc.l2weaponry.content.item.base.IStackableWeapon;
import dev.xkmc.l2weaponry.init.L2Weaponry;
import dev.xkmc.l2weaponry.init.data.LangData;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CursiumTool
extends ExtraToolConfig
implements LWExtraConfig {
    private static final ResourceLocation ID = L2Weaponry.loc("cursium");

    public void onDamage(DamageData.Offence cache, ItemStack stack) {
        Item item;
        int count = IStackableWeapon.getHitCount(stack);
        LivingEntity attacker = cache.getAttacker();
        if (count > 0 && attacker != null && (item = stack.getItem()) instanceof IStackableWeapon) {
            IStackableWeapon item2 = (IStackableWeapon)item;
            int max = item2.getMaxStack(stack, attacker);
            float bonus = 0.2f * (float)Mth.clamp((int)count, (int)0, (int)max);
            cache.addHurtModifier(DamageModifier.multTotal((float)(1.0f + bonus), (ResourceLocation)ID));
        }
    }

    @Override
    public int getExtraStacking(ItemStack stack, @Nullable LivingEntity user) {
        return 5;
    }

    public void addTooltip(ItemStack stack, List<Component> list) {
        list.add((Component)LangData.MATS_CURSIUM.get(new Object[0]));
        if (stack.getItem() instanceof BaseThrowableWeaponItem) {
            list.add((Component)LangData.MATS_CURSIUM_PROJ.get(new Object[0]));
        }
    }

    @Override
    public void onHitBlock(BaseThrownWeaponEntity<?> entity, ItemStack stack) {
        if (entity.getTags().contains(ID.toString())) {
            return;
        }
        entity.addTag(ID.toString());
        Entity entity2 = entity.getOwner();
        if (entity2 instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity2;
            CataclysmProxy.spawnHalberd(entity.position(), e, 1);
        }
    }

    @Override
    public void onHitEntity(BaseThrownWeaponEntity<?> entity, ItemStack stack, LivingEntity target) {
        if (entity.getTags().contains(ID.toString())) {
            return;
        }
        entity.addTag(ID.toString());
        Entity entity2 = entity.getOwner();
        if (entity2 instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity2;
            CataclysmProxy.spawnHalberd(target.position(), e, 1);
        }
    }
}

