/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.cataclysm;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.projectile.Phantom_Halberd_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import dev.xkmc.l2weaponry.init.L2Weaponry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CataclysmProxy {
    public static void stackBlazingBrand(LivingEntity user, LivingEntity target, float factor) {
        try {
            DeferredHolder eff = ModEffect.EFFECTBLAZING_BRAND;
            MobEffectInstance old = target.getEffect((Holder)eff);
            int i = old == null ? 0 : Math.min(4, old.getAmplifier() + 1);
            MobEffectInstance ins = new MobEffectInstance((Holder)eff, 240, i, false, true, true);
            target.addEffect(ins);
            user.heal(factor * (float)CMConfig.IgnisHealingMultiplier * (float)(i + 1));
        }
        catch (Throwable e) {
            L2Weaponry.LOGGER.error((Object)e);
        }
    }

    public static void inflictStun(LivingEntity user, LivingEntity target, int time) {
        try {
            DeferredHolder eff = ModEffect.EFFECTSTUN;
            MobEffectInstance ins = new MobEffectInstance((Holder)eff, time, 0, false, true, true);
            target.addEffect(ins);
        }
        catch (Throwable e) {
            L2Weaponry.LOGGER.error((Object)e);
        }
    }

    public static int spawnHalberd(Vec3 pos, LivingEntity player, int delay) {
        try {
            Level var2 = player.level();
            if (var2 instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)var2;
                CataclysmProxy.strikeWindmillHalberd(sl, pos, player, 7, 5, 1.0, 1.0, 0.2, delay);
            }
            return CMConfig.SoulRenderCooldown;
        }
        catch (Throwable e) {
            L2Weaponry.LOGGER.throwing(e);
            return 20;
        }
    }

    private static void strikeWindmillHalberd(ServerLevel level, Vec3 pos, LivingEntity user, int numberOfBranches, int particlesPerBranch, double initialRadius, double radiusIncrement, double curveFactor, int delay) {
        float angleIncrement = (float)(Math.PI * 2 / (double)numberOfBranches);
        for (int branch = 0; branch < numberOfBranches; ++branch) {
            float baseAngle = angleIncrement * (float)branch;
            for (int i = 0; i < particlesPerBranch; ++i) {
                double currentRadius = initialRadius + (double)i * radiusIncrement;
                float currentAngle = (float)((double)baseAngle + (double)((float)i * angleIncrement) / initialRadius + (double)((float)((double)i * curveFactor)));
                double xOffset = currentRadius * Math.cos(currentAngle);
                double zOffset = currentRadius * Math.sin(currentAngle);
                double spawnX = pos.x() + xOffset;
                double spawnY = pos.y() + 0.3;
                double spawnZ = pos.z() + zOffset;
                int d3 = delay + i + 1;
                level.sendParticles((ParticleOptions)((SimpleParticleType)ModParticle.PHANTOM_WING_FLAME.get()), spawnX, spawnY, spawnZ, 1, 0.0, 0.0, 0.0, 0.007);
                CataclysmProxy.spawnHalberd(spawnX, spawnZ, pos.y() - 5.0, pos.y() + 3.0, currentAngle, d3, (Level)level, user);
            }
        }
    }

    private static void spawnHalberd(double x, double z, double minY, double maxY, float rotation, int delay, Level world, LivingEntity player) {
        BlockPos blockpos = BlockPos.containing((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = world.getBlockState(blockpos1 = blockpos.below())).isFaceSturdy((BlockGetter)world, blockpos1, Direction.UP)) continue;
            if (!world.isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = world.getBlockState(blockpos)).getCollisionShape((BlockGetter)world, blockpos)).isEmpty()) {
                d0 = voxelshape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (flag) {
            world.addFreshEntity((Entity)new Phantom_Halberd_Entity(world, x, (double)blockpos.getY() + d0, z, rotation, delay, player, (float)CMConfig.PhantomHalberddamage));
        }
    }
}

