/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.cataclysm;

import com.github.L_Ender.cataclysm.init.ModBlocks;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.items.Tooltier;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.l2core.util.MathHelper;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatToolType;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.compat.ModMats;
import dev.xkmc.l2weaponry.compat.cataclysm.AncientMetalTool;
import dev.xkmc.l2weaponry.compat.cataclysm.CataCompat;
import dev.xkmc.l2weaponry.compat.cataclysm.CataTiers;
import dev.xkmc.l2weaponry.compat.cataclysm.CursiumTool;
import dev.xkmc.l2weaponry.compat.cataclysm.IgnitiumTool;
import dev.xkmc.l2weaponry.compat.cataclysm.WitheriteTool;
import dev.xkmc.l2weaponry.init.materials.ILWToolMats;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import dev.xkmc.l2weaponry.init.materials.LWToolTypes;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public enum CataToolMats implements ILWToolMats
{
    IGNITIUM(new ModMats(() -> CataTiers.IGNITIUM, new IgnitiumTool(), true), (Supplier<Item>)ModItems.IGNITIUM_INGOT, (Supplier<Block>)ModBlocks.IGNITIUM_BLOCK),
    WITHERITE(new ModMats(() -> CataTiers.WITHERITE, new WitheriteTool(), true), (Supplier<Item>)ModItems.WITHERITE_INGOT, (Supplier<Block>)ModBlocks.WITHERITE_BLOCK),
    CURSIUM(new ModMats(() -> CataTiers.CURSIUM, new CursiumTool(), true), (Supplier<Item>)ModItems.CURSIUM_INGOT, (Supplier<Block>)ModBlocks.CURSIUM_BLOCK),
    ANCIENT_METAL(new ModMats(() -> CataTiers.ANCIENT_METAL, new AncientMetalTool(), false), (Supplier<Item>)ModItems.ANCIENT_METAL_INGOT, (Supplier<Block>)ModBlocks.ANCIENT_METAL_BLOCK),
    BLACK_STEEL(new ModMats(() -> Tooltier.BLACK_STEEL, new ExtraToolConfig(), false), (Supplier<Item>)ModItems.BLACK_STEEL_INGOT, (Supplier<Block>)ModBlocks.BLACK_STEEL_BLOCK);

    private final IMatToolType type;
    private final Supplier<Item> ingot;
    private final Supplier<Block> block;

    private CataToolMats(IMatToolType type, Supplier<Item> ingot, Supplier<Block> block) {
        this.type = type;
        this.ingot = ingot;
        this.block = block;
    }

    @Override
    public IMatToolType type() {
        return this.type;
    }

    @Override
    public boolean fireRes() {
        return true;
    }

    @Override
    public Item getTool(LWToolTypes type) {
        return (Item)CataCompat.ITEMS[this.ordinal()][type.ordinal()].get();
    }

    @Override
    public Item getIngot() {
        return this.ingot.get();
    }

    @Override
    public Item getBlock() {
        return this.block.get().asItem();
    }

    @Override
    public Item getStick() {
        return switch (this.ordinal()) {
            case 0 -> Items.BLAZE_ROD;
            case 1 -> Items.NETHERITE_INGOT;
            case 2 -> (Item)ModItems.BLACK_STEEL_INGOT.get();
            default -> (Item)LWItems.HANDLE.get();
        };
    }

    @Override
    public void addEnchants(HolderLookup.Provider pvd, List<LWToolTypes.DefaultEnch> list, LWToolTypes type) {
        ExtraToolConfig extraToolConfig = this.type.getExtraToolConfig();
        if (extraToolConfig instanceof LWExtraConfig) {
            LWExtraConfig lw = (LWExtraConfig)extraToolConfig;
            lw.addEnchants(list, type, this.getTool(type));
        }
    }

    @Override
    public RecipeOutput getProvider(RegistrateRecipeProvider pvd, ICondition ... cond) {
        return ILWToolMats.super.getProvider(pvd, (ICondition[])MathHelper.merge((Object[])cond, (Object[])new ICondition[]{new ModLoadedCondition("cataclysm")}));
    }

    @Override
    public boolean hasTool(LWToolTypes type) {
        return switch (type) {
            case LWToolTypes.CLAW, LWToolTypes.DAGGER, LWToolTypes.NUNCHAKU, LWToolTypes.SPEAR, LWToolTypes.JAVELIN, LWToolTypes.THROWING_AXE, LWToolTypes.SCYTHE, LWToolTypes.BATTLE_AXE, LWToolTypes.MACHETE -> true;
            default -> false;
        };
    }

    @Override
    public boolean is3D(LWToolTypes type) {
        return type == LWToolTypes.JAVELIN;
    }

    @Override
    public boolean isOptional() {
        return true;
    }
}

