/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.cataclysm;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.compat.cataclysm.CataclysmProxy;
import dev.xkmc.l2weaponry.content.item.base.IExplosionSource;
import dev.xkmc.l2weaponry.content.item.base.IStackableWeapon;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.content.item.types.MacheteItem;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.data.LangData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class AncientTraveller
extends MacheteItem
implements LegendaryWeapon,
IExplosionSource {
    public AncientTraveller(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config);
    }

    @Override
    public void onDamageFinal(DamageData.DefenceMax data, LivingEntity le) {
        if ((double)data.getStrength() < 0.95) {
            return;
        }
        LivingEntity attacker = data.getAttacker();
        if (attacker == null) {
            return;
        }
        CataclysmProxy.inflictStun(attacker, data.getTarget(), 20);
    }

    @Override
    public void onAffecting(LivingEntity attacker, Entity entity, ItemStack stack) {
        Item item;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        int time = 20;
        int count = IStackableWeapon.getHitCount(stack);
        if (count > 0 && (item = stack.getItem()) instanceof IStackableWeapon) {
            IStackableWeapon item2 = (IStackableWeapon)item;
            int max = item2.getMaxStack(stack, attacker);
            double bonus = 1.0 + (Double)LWConfig.SERVER.claw_bonus.get() * (double)Mth.clamp((int)count, (int)0, (int)max);
            time = (int)((double)time * bonus);
        }
        CataclysmProxy.inflictStun(attacker, le, time);
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pLevel, list, pIsAdvanced);
        list.add((Component)LangData.MATS_ANCIENT_TRAVELLER.get(new Object[0]));
    }
}

