/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.atm;

import com.mojang.datafixers.util.Pair;
import com.thevortex.allthemodium.material.ATMTier;
import com.thevortex.allthemodium.registry.ModRegistry;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.l2complements.content.enchantment.digging.RangeDiggingEnchantment;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2core.init.L2LibReg;
import dev.xkmc.l2core.util.MathHelper;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatToolType;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.compat.ModMats;
import dev.xkmc.l2weaponry.compat.atm.ATMCompat;
import dev.xkmc.l2weaponry.compat.atm.ATMTool;
import dev.xkmc.l2weaponry.init.materials.ILWToolMats;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import dev.xkmc.l2weaponry.init.materials.LWToolMats;
import dev.xkmc.l2weaponry.init.materials.LWToolTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public enum ATMToolMats implements ILWToolMats
{
    ALLTHEMODIUM(new ModMats(() -> ATMTier.ALLTHEMODIUM, new ATMTool(1), true), true, (Supplier<Item>)ModRegistry.ALLTHEMODIUM_INGOT, (Supplier<Block>)ModRegistry.ALLTHEMODIUM_BLOCK),
    VIBRANIUM(new ModMats(() -> ATMTier.VIBRANIUM, new ATMTool(2), true), true, (Supplier<Item>)ModRegistry.VIBRANIUM_INGOT, (Supplier<Block>)ModRegistry.VIBRANIUM_BLOCK),
    UNOBTAINIUM(new ModMats(() -> ATMTier.UNOBTAINIUM, new ATMTool(3), true), true, (Supplier<Item>)ModRegistry.UNOBTAINIUM_INGOT, (Supplier<Block>)ModRegistry.UNOBTAINIUM_BLOCK);

    private final IMatToolType type;
    private final boolean fireRes;
    private final Supplier<Item> ingot;
    private final Supplier<Block> block;

    private ATMToolMats(IMatToolType type, boolean fireRes, Supplier<Item> ingot, Supplier<Block> block) {
        this.type = type;
        this.fireRes = fireRes;
        this.ingot = ingot;
        this.block = block;
    }

    @Override
    public IMatToolType type() {
        return this.type;
    }

    @Override
    public boolean fireRes() {
        return this.fireRes;
    }

    @Override
    public Item getTool(LWToolTypes type) {
        return (Item)ATMCompat.ITEMS[this.ordinal()][type.ordinal()].get();
    }

    @Override
    public Item getIngot() {
        return this.ingot.get();
    }

    @Override
    public Item getBlock() {
        return this.block.get().asItem();
    }

    @Override
    public Item getStick() {
        return Items.STICK;
    }

    @Override
    public boolean hasTool(LWToolTypes type) {
        return type != LWToolTypes.ROUND_SHIELD && type != LWToolTypes.PLATE_SHIELD;
    }

    @Override
    public void addEnchants(HolderLookup.Provider pvd, List<LWToolTypes.DefaultEnch> list, LWToolTypes type) {
        ExtraToolConfig extraToolConfig = this.type.getExtraToolConfig();
        if (extraToolConfig instanceof LWExtraConfig) {
            LWExtraConfig lw = (LWExtraConfig)extraToolConfig;
            lw.addEnchants(list, type, this.getTool(type));
        }
        ArrayList<LWToolTypes.DefaultEnch> copy = new ArrayList<LWToolTypes.DefaultEnch>(list);
        list.clear();
        boolean dig = false;
        for (LWToolTypes.DefaultEnch e : copy) {
            int max = ((Enchantment)pvd.holderOrThrow(e.key()).value()).getMaxLevel();
            list.add(new LWToolTypes.DefaultEnch(e.key(), Math.min(e.lv() + this.ordinal() + 1, max)));
            if (!(L2LibReg.ENCH.get().get(e.key().location()) instanceof RangeDiggingEnchantment)) continue;
            dig = true;
        }
        if (dig) {
            list.add(new LWToolTypes.DefaultEnch((ResourceKey<Enchantment>)LCEnchantments.ENDER_TRANSPORT.id(), 1));
        }
    }

    @Override
    public RecipeOutput getProvider(RegistrateRecipeProvider pvd, ICondition ... cond) {
        return ILWToolMats.super.getProvider(pvd, (ICondition[])MathHelper.merge((Object[])cond, (Object[])new ICondition[]{new ModLoadedCondition("allthemodium")}));
    }

    @Override
    public boolean isOptional() {
        return true;
    }

    @Override
    public Pair<ILWToolMats, Item> getBaseUpgrade() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Pair.of((Object)LWToolMats.NETHERITE, (Object)((Item)ModRegistry.ATM_SMITHING.get()));
            case 1 -> Pair.of((Object)ALLTHEMODIUM, (Object)((Item)ModRegistry.VIB_SMITHING.get()));
            case 2 -> Pair.of((Object)VIBRANIUM, (Object)((Item)ModRegistry.UNO_SMITHING.get()));
        };
    }

    @Override
    public boolean is3D(LWToolTypes type) {
        return type == LWToolTypes.BATTLE_AXE || type == LWToolTypes.HAMMER || type == LWToolTypes.JAVELIN || type == LWToolTypes.SPEAR || type == LWToolTypes.SCYTHE;
    }
}

