/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat.atm;

import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import java.util.Optional;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class ATMTool
extends ExtraToolConfig {
    private final int rank;

    public ATMTool(int rank) {
        this.rank = rank;
    }

    public void configureAttributes(ItemAttributeModifiers.Builder builder) {
        ItemAttributeModifiers prev = builder.build();
        Optional<ItemAttributeModifiers.Entry> lowRange = prev.modifiers().stream().filter(e -> e.attribute().is(Attributes.ENTITY_INTERACTION_RANGE.getKey()) && e.modifier().amount() < 0.0).findFirst();
        Optional<ItemAttributeModifiers.Entry> highRange = prev.modifiers().stream().filter(e -> e.attribute().is(Attributes.ENTITY_INTERACTION_RANGE.getKey()) && e.modifier().amount() > 0.0).findFirst();
        Optional<ItemAttributeModifiers.Entry> speed = prev.modifiers().stream().filter(e -> e.attribute().is(Attributes.ATTACK_SPEED.getKey()) && e.modifier().operation() == AttributeModifier.Operation.ADD_VALUE).findFirst();
        Optional<ItemAttributeModifiers.Entry> heavy = prev.modifiers().stream().filter(e -> e.attribute().is(Attributes.ATTACK_SPEED.getKey()) && e.modifier().operation() != AttributeModifier.Operation.ADD_VALUE).findFirst();
        if (highRange.isPresent() || heavy.isPresent() || speed.isPresent() && speed.get().modifier().amount() < -3.05) {
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(L2Complements.loc((String)"atm_tool"), 0.2 * (double)this.rank, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND);
        } else if (lowRange.isPresent() || speed.isPresent() && speed.get().modifier().amount() > -2.2) {
            builder.add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(L2Complements.loc((String)"atm_tool"), 0.5 * (double)this.rank, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(L2Complements.loc((String)"atm_tool"), 0.5 * (double)this.rank, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        } else {
            builder.add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(L2Complements.loc((String)"atm_tool"), 0.25 * (double)this.rank, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(L2Complements.loc((String)"atm_tool"), 0.25 * (double)this.rank, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(L2Complements.loc((String)"atm_tool"), 0.1 * (double)this.rank, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND);
        }
    }
}

