/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.compat;

import dev.xkmc.l2weaponry.content.capability.MobShieldGoal;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import dev.xkmc.l2weaponry.content.item.base.BaseShieldItem;
import dev.xkmc.l2weaponry.content.item.base.BaseThrowableWeaponItem;
import dev.xkmc.l2weaponry.content.item.base.GenericShieldItem;
import dev.xkmc.l2weaponry.content.item.base.WeaponItem;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.events.event.GolemDamageShieldEvent;
import dev.xkmc.modulargolems.events.event.GolemDisableShieldEvent;
import dev.xkmc.modulargolems.events.event.GolemEquipEvent;
import dev.xkmc.modulargolems.events.event.GolemSweepEvent;
import dev.xkmc.modulargolems.events.event.GolemThrowableEvent;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;

public class GolemCompat {
    public static void register(IEventBus bus) {
        NeoForge.EVENT_BUS.register(GolemCompat.class);
        bus.addListener(GolemCompat::onGolemSpawn);
    }

    public static void onGolemSpawn(EntityAttributeModificationEvent event) {
        event.add((EntityType)GolemTypes.ENTITY_HUMANOID.get(), LWItems.SHIELD_DEFENSE.holder());
        event.add((EntityType)GolemTypes.ENTITY_HUMANOID.get(), LWItems.REFLECT_TIME.holder());
    }

    @SubscribeEvent
    public static void onEquip(GolemEquipEvent event) {
        Item item = event.getStack().getItem();
        if (item instanceof GenericShieldItem) {
            GenericShieldItem item2 = (GenericShieldItem)item;
            if (item2.lightWeight(event.getStack()) && event.getEntity().getItemBySlot(EquipmentSlot.OFFHAND).isEmpty()) {
                event.setSlot(EquipmentSlot.OFFHAND, 1);
            } else {
                event.setSlot(EquipmentSlot.MAINHAND, 1);
            }
        }
    }

    @SubscribeEvent
    public static void onThrow(GolemThrowableEvent event) {
        HumanoidGolemEntity golem = event.getEntity();
        Item item = event.getStack().getItem();
        if (item instanceof BaseThrowableWeaponItem) {
            BaseThrowableWeaponItem item2 = (BaseThrowableWeaponItem)item;
            event.setThrowable(level -> {
                BaseThrownWeaponEntity<?> ans = item2.getProjectile((Level)level, (LivingEntity)golem, event.getStack(), 0);
                ans.setBaseDamage(golem.getAttributeValue(Attributes.ATTACK_DAMAGE));
                return ans;
            });
        }
    }

    @SubscribeEvent
    public static void onBlock(GolemDisableShieldEvent event) {
        ItemStack stack = event.getStack();
        Item item = stack.getItem();
        if (item instanceof BaseShieldItem) {
            BaseShieldItem item2 = (BaseShieldItem)item;
            HumanoidGolemEntity golem = event.getEntity();
            MobShieldGoal goal = MobShieldGoal.getShieldGoal((Mob)golem);
            event.setDisabled(goal.onBlock(stack, item2, event.shouldDisable(), event.getSource()));
        }
    }

    @SubscribeEvent
    public static void onDamageShield(GolemDamageShieldEvent event) {
        ItemStack stack = event.getStack();
        Item item = stack.getItem();
        if (item instanceof BaseShieldItem) {
            BaseShieldItem item2 = (BaseShieldItem)item;
            HumanoidGolemEntity golem = event.getEntity();
            MobShieldGoal goal = MobShieldGoal.getShieldGoal((Mob)golem);
            goal.onShieldDamage(stack, item2, event.getDamage());
        }
    }

    @SubscribeEvent
    public static void onSweep(GolemSweepEvent event) {
        Item item = event.getStack().getItem();
        if (item instanceof WeaponItem) {
            WeaponItem weapon = (WeaponItem)item;
            event.setBox(weapon.getSweepHitBoxImpl(event.getStack(), (LivingEntity)event.getEntity(), event.getTarget()));
        }
    }
}

