/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.util;

import com.blakebr0.mysticalcustomization.MysticalCustomization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public final class ErrorManager {
    public static final ErrorManager INSTANCE = new ErrorManager();
    private final Map<String, List<String>> errors = new HashMap<String, List<String>>();

    public void addError(String category, String message) {
        this.errors.computeIfAbsent(category, k -> new ArrayList()).add(message);
        MysticalCustomization.LOGGER.error("Error ({}): {}", (Object)category, (Object)message);
    }

    public void addFatalError(String category, String message, Exception exception) {
        this.errors.computeIfAbsent(category, k -> new ArrayList()).add(message + " Check the log for more information.");
        MysticalCustomization.LOGGER.error(message, (Throwable)exception);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!this.errors.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)"Mystical Customization errors have occurred:"));
        }
        for (Map.Entry<String, List<String>> category : this.errors.entrySet()) {
            player.sendSystemMessage((Component)Component.literal((String)" %s:".formatted(category.getKey())));
            for (String error : category.getValue()) {
                player.sendSystemMessage((Component)Component.literal((String)"  - %s".formatted(error)));
            }
        }
    }
}

