/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.init.registrate;

import com.google.common.collect.ImmutableList;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.BleedingArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.DamageModifierArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.DamageSourceArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.EnderArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.ExplodeArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.ExplosionBreakFeature;
import dev.xkmc.l2archery.content.feature.arrow.FireArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.NoFallArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.VoidArrowFeature;
import dev.xkmc.l2archery.content.feature.bow.DoubleChargeFeature;
import dev.xkmc.l2archery.content.feature.bow.EnderShootFeature;
import dev.xkmc.l2archery.content.feature.bow.FluxFeature;
import dev.xkmc.l2archery.content.feature.bow.GlowTargetAimFeature;
import dev.xkmc.l2archery.content.feature.bow.InfinityFeature;
import dev.xkmc.l2archery.content.feature.bow.PullEffectFeature;
import dev.xkmc.l2archery.content.feature.bow.WindBowFeature;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.feature.materials.PoseiditeArrowFeature;
import dev.xkmc.l2archery.content.feature.materials.TotemicArrowFeature;
import dev.xkmc.l2archery.content.item.ArrowConfig;
import dev.xkmc.l2archery.content.item.BowConfig;
import dev.xkmc.l2archery.content.item.BowHandTransform;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.upgrade.BowUpgrade;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.content.upgrade.UpgradeItem;
import dev.xkmc.l2archery.init.L2Archery;
import dev.xkmc.l2archery.init.data.ArcheryDamageState;
import dev.xkmc.l2archery.init.data.ArcheryTagGen;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import dev.xkmc.l2complements.init.materials.LCMats;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.registrate.SimpleEntry;
import dev.xkmc.l2core.init.reg.simple.DCReg;
import dev.xkmc.l2core.init.reg.simple.DCVal;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class ArcheryItems {
    public static final List<GenericBowItem> BOW_LIKE = new ArrayList<GenericBowItem>();
    private static final SimpleEntry<CreativeModeTab> TAB = L2Archery.REGISTRATE.buildL2CreativeTab("archery", "L2 Archery", b -> b.icon(() -> STARTER_BOW.asStack()));
    public static final ItemEntry<GenericBowItem> STARTER_BOW;
    public static final ItemEntry<GenericBowItem> IRON_BOW;
    public static final ItemEntry<GenericBowItem> MASTER_BOW;
    public static final ItemEntry<GenericBowItem> MAGNIFY_BOW;
    public static final ItemEntry<GenericBowItem> GLOW_AIM_BOW;
    public static final ItemEntry<GenericBowItem> ENDER_AIM_BOW;
    public static final ItemEntry<GenericBowItem> EAGLE_BOW;
    public static final ItemEntry<GenericBowItem> WIND_BOW;
    public static final ItemEntry<GenericBowItem> EXPLOSION_BOW;
    public static final ItemEntry<GenericBowItem> FLAME_BOW;
    public static final ItemEntry<GenericBowItem> FROZE_BOW;
    public static final ItemEntry<GenericBowItem> STORM_BOW;
    public static final ItemEntry<GenericBowItem> BLACKSTONE_BOW;
    public static final ItemEntry<GenericBowItem> WINTER_BOW;
    public static final ItemEntry<GenericBowItem> TURTLE_BOW;
    public static final ItemEntry<GenericBowItem> EARTH_BOW;
    public static final ItemEntry<GenericBowItem> GAIA_BOW;
    public static final ItemEntry<GenericBowItem> VOID_BOW;
    public static final ItemEntry<GenericBowItem> SUN_BOW;
    public static final ItemEntry<GenericArrowItem> STARTER_ARROW;
    public static final ItemEntry<GenericArrowItem> COPPER_ARROW;
    public static final ItemEntry<GenericArrowItem> IRON_ARROW;
    public static final ItemEntry<GenericArrowItem> GOLD_ARROW;
    public static final ItemEntry<GenericArrowItem> OBSIDIAN_ARROW;
    public static final ItemEntry<GenericArrowItem> NO_FALL_ARROW;
    public static final ItemEntry<GenericArrowItem> ENDER_ARROW;
    public static final ItemEntry<GenericArrowItem> TNT_1_ARROW;
    public static final ItemEntry<GenericArrowItem> TNT_2_ARROW;
    public static final ItemEntry<GenericArrowItem> TNT_3_ARROW;
    public static final ItemEntry<GenericArrowItem> FIRE_1_ARROW;
    public static final ItemEntry<GenericArrowItem> FIRE_2_ARROW;
    public static final ItemEntry<GenericArrowItem> DESTROYER_ARROW;
    public static final ItemEntry<GenericArrowItem> ICE_ARROW;
    public static final ItemEntry<GenericArrowItem> DISPELL_ARROW;
    public static final ItemEntry<GenericArrowItem> ACID_ARROW;
    public static final ItemEntry<GenericArrowItem> BLACKSTONE_ARROW;
    public static final ItemEntry<GenericArrowItem> DIAMOND_ARROW;
    public static final ItemEntry<GenericArrowItem> QUARTZ_ARROW;
    public static final ItemEntry<GenericArrowItem> WITHER_ARROW;
    public static final ItemEntry<GenericArrowItem> STORM_ARROW;
    public static final ItemEntry<GenericArrowItem> VOID_ARROW;
    public static final ItemEntry<GenericArrowItem> TOTEMIC_GOLD_ARROW;
    public static final ItemEntry<GenericArrowItem> POSEIDITE_ARROW;
    public static final ItemEntry<GenericArrowItem> SHULKERATE_ARROW;
    public static final ItemEntry<GenericArrowItem> SCULKIUM_ARROW;
    public static final ItemEntry<GenericArrowItem> ETERNIUM_ARROW;
    public static final ItemEntry<GenericArrowItem> TEARING_ARROW;
    public static final ItemEntry<UpgradeItem> UPGRADE;
    public static final SimpleEntry<Upgrade> GLOW_UP;
    public static final SimpleEntry<Upgrade> NO_FALL_UP;
    public static final SimpleEntry<Upgrade> FIRE_UP;
    public static final SimpleEntry<Upgrade> ICE_UP;
    public static final SimpleEntry<Upgrade> EXPLOSION_UP;
    public static final SimpleEntry<Upgrade> ENDER_UP;
    public static final SimpleEntry<Upgrade> MAGNIFY_UP_1;
    public static final SimpleEntry<Upgrade> MAGNIFY_UP_2;
    public static final SimpleEntry<Upgrade> MAGNIFY_UP_3;
    public static final SimpleEntry<Upgrade> DAMAGE_UP;
    public static final SimpleEntry<Upgrade> PUNCH_UP;
    public static final SimpleEntry<Upgrade> BLACKSTONE_UP;
    public static final SimpleEntry<Upgrade> HARM_UP;
    public static final SimpleEntry<Upgrade> HEAL_UP;
    public static final SimpleEntry<Upgrade> SHINE_UP;
    public static final SimpleEntry<Upgrade> LEVITATE_UP;
    public static final SimpleEntry<Upgrade> SUPERDAMAGE_UP;
    public static final SimpleEntry<Upgrade> RAILGUN_UP;
    public static final SimpleEntry<Upgrade> FLUX_UP;
    public static final SimpleEntry<Upgrade> FLOAT_UP;
    public static final SimpleEntry<Upgrade> SLOW_UP;
    public static final SimpleEntry<Upgrade> POISON_UP;
    public static final SimpleEntry<Upgrade> WITHER_UP;
    public static final SimpleEntry<Upgrade> WEAK_UP;
    public static final SimpleEntry<Upgrade> CORROSION_UP;
    public static final SimpleEntry<Upgrade> CURSE_UP;
    public static final SimpleEntry<Upgrade> CLEANSE_UP;
    public static final SimpleEntry<Upgrade> ADVANCED_INFINITY;
    public static final SimpleEntry<Upgrade> EXPLOSION_BREAKER;
    public static final SimpleEntry<Upgrade> DOUBLE_CHARGE;
    public static final DCReg DC;
    public static final DCVal<Upgrade> ITEM_UPGRADE;
    public static final DCVal<BowUpgrade> BOW_UPGRADE;
    public static final DCVal<Integer> ENERGY;
    private static final float[] BOW_PULL_VALS;

    public static void register() {
    }

    public static ItemBuilder<GenericBowItem, L2Registrate> genBow(String id, int rank, int durability) {
        return ArcheryItems.genBow(id, rank, durability, e -> {});
    }

    public static ItemBuilder<GenericBowItem, L2Registrate> genBow(String id, int rank, int durability, Consumer<ImmutableList.Builder<BowArrowFeature>> consumer) {
        ImmutableList.Builder f = ImmutableList.builder();
        consumer.accept((ImmutableList.Builder<BowArrowFeature>)f);
        return L2Archery.REGISTRATE.item(id, p -> new GenericBowItem(p.stacksTo(1).durability(durability).rarity(Rarity.values()[rank]), e -> new BowConfig((GenericBowItem)e, rank, (List<BowArrowFeature>)f.build()))).model(ArcheryItems::createBowModel).clientExtension(() -> BowHandTransform::new).defaultLang().tag(new TagKey[]{ArcheryTagGen.FORGE_BOWS, ArcheryTagGen.PROF_BOWS});
    }

    public static <T extends GenericBowItem> void createBowModel(DataGenContext<Item, T> ctx, RegistrateItemModelProvider pvd) {
        ItemModelBuilder builder = (ItemModelBuilder)pvd.withExistingParent(ctx.getName(), "minecraft:bow");
        builder.texture("layer0", "item/bow/" + ctx.getName() + "/bow");
        for (int i = 0; i < 3; ++i) {
            String name = ctx.getName() + "/bow_pulling_" + i;
            ItemModelBuilder ret = (ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder("item/bow/" + name)).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/bow_pulling_" + i));
            ret.texture("layer0", "item/bow/" + name);
            ItemModelBuilder.OverrideBuilder override = builder.override();
            override.predicate(ResourceLocation.withDefaultNamespace((String)"pulling"), 1.0f);
            if (BOW_PULL_VALS[i] > 0.0f) {
                override.predicate(ResourceLocation.withDefaultNamespace((String)"pull"), BOW_PULL_VALS[i]);
            }
            override.model((ModelFile)new ModelFile.UncheckedModelFile("l2archery:item/bow/" + name));
        }
    }

    public static ItemEntry<GenericArrowItem> genArrow(String id, int infLevel) {
        return ArcheryItems.genArrow(id, infLevel, e -> {}).register();
    }

    public static ItemBuilder<GenericArrowItem, L2Registrate> genArrow(String id, int infLevel, Consumer<ImmutableList.Builder<BowArrowFeature>> consumer) {
        ImmutableList.Builder f = ImmutableList.builder();
        consumer.accept((ImmutableList.Builder<BowArrowFeature>)f);
        return L2Archery.REGISTRATE.item(id, p -> new GenericArrowItem((Item.Properties)p, e -> new ArrowConfig((GenericArrowItem)((Object)((Object)e)), infLevel, (List<BowArrowFeature>)f.build()))).model(ArcheryItems::createArrowModel).tag(new TagKey[]{ArcheryTagGen.FORGE_ARROWS, ArcheryTagGen.PROF_ARROWS}).defaultLang();
    }

    public static <T extends GenericArrowItem> void createArrowModel(DataGenContext<Item, T> ctx, RegistrateItemModelProvider pvd) {
        pvd.generated(ctx, new ResourceLocation[]{L2Archery.loc("item/arrow/" + ctx.getName())});
    }

    public static SimpleEntry<Upgrade> genUpgrade(String str, Supplier<BowArrowFeature> sup) {
        return new SimpleEntry(L2Archery.REGISTRATE.generic(ArcheryRegister.UPGRADE, str, () -> new Upgrade(sup)).defaultLang().register());
    }

    public static SimpleEntry<Upgrade> genPotionUpgrade(String str) {
        return new SimpleEntry(L2Archery.REGISTRATE.generic(ArcheryRegister.UPGRADE, str, () -> new Upgrade(PotionArrowFeature::fromUpgradeConfig)).defaultLang().register());
    }

    static {
        DC = DCReg.of((Reg)L2Archery.REG);
        ITEM_UPGRADE = DC.reg("item_upgrade", Upgrade.class, true);
        BOW_UPGRADE = DC.reg("bow_upgrade", BowUpgrade.class, true);
        ENERGY = DC.intVal("energy");
        STARTER_BOW = ArcheryItems.genBow("starter_bow", 0, 600).register();
        IRON_BOW = ArcheryItems.genBow("iron_bow", 1, 1200).register();
        MASTER_BOW = ArcheryItems.genBow("master_bow", 1, 1200).register();
        GLOW_AIM_BOW = ArcheryItems.genBow("glow_aim_bow", 1, 300, e -> e.add((Object)new NoFallArrowFeature(40)).add((Object)new GlowTargetAimFeature(128))).lang("Sniper Bow").register();
        MAGNIFY_BOW = ArcheryItems.genBow("magnify_bow", 2, 300, e -> e.add((Object)new NoFallArrowFeature(40)).add((Object)new GlowTargetAimFeature(128))).lang("Sniper Bow with Lens").register();
        ENDER_AIM_BOW = ArcheryItems.genBow("ender_aim_bow", 2, 600, e -> e.add((Object)new EnderShootFeature(128))).lang("Ender Bow").register();
        EAGLE_BOW = ArcheryItems.genBow("eagle_bow", 2, 600, e -> e.add((Object)new DamageSourceArrowFeature((a, s) -> s.enable((DamageState)DefaultDamageState.BYPASS_ARMOR), () -> LangData.FEATURE_PIERCE_ARMOR.get(new Object[0])))).register();
        EXPLOSION_BOW = ArcheryItems.genBow("explosion_bow", 2, 300, e -> e.add((Object)new ExplodeArrowFeature(3.0f, true, false))).register();
        FLAME_BOW = ArcheryItems.genBow("flame_bow", 2, 600, e -> e.add((Object)new FireArrowFeature(100))).lang("Blazing Bow").register();
        FROZE_BOW = ArcheryItems.genBow("froze_bow", 2, 600).lang("Freezing Bow").register();
        BLACKSTONE_BOW = ArcheryItems.genBow("slow_bow", 2, 600).lang("Bow of Seal").register();
        STORM_BOW = ArcheryItems.genBow("storm_bow", 2, 600, e -> e.add((Object)new ExplodeArrowFeature(3.0f, false, false))).lang("Approaching Storm").register();
        TURTLE_BOW = ArcheryItems.genBow("turtle_bow", 2, 600, e -> e.add((Object)new PullEffectFeature(List.of(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 3), () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40, 2))))).register();
        EARTH_BOW = ArcheryItems.genBow("earth_bow", 2, 600, e -> e.add((Object)new PullEffectFeature(List.of(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 5), () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60, 3))))).lang("Bow of the Earth").register();
        WIND_BOW = ArcheryItems.genBow("wind_bow", 3, 600, e -> e.add((Object)new NoFallArrowFeature(40)).add((Object)new WindBowFeature()).add((Object)new PullEffectFeature(List.of(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100, 1))))).lang("Bless of Favonius").register();
        WINTER_BOW = ArcheryItems.genBow("winter_bow", 3, 600, e -> e.add((Object)new ExplodeArrowFeature(3.0f, false, false))).lang("Ever Freezing Night").register();
        GAIA_BOW = ArcheryItems.genBow("gaia_bow", 3, 600, e -> e.add((Object)new PullEffectFeature(List.of(() -> new MobEffectInstance((Holder)LCEffects.INCARCERATE, 80, 0), () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 80, 4))))).lang("Bless of Gaia").register();
        VOID_BOW = ArcheryItems.genBow("void_bow", 3, 300, e -> e.add((Object)new EnderShootFeature(128)).add((Object)new DamageSourceArrowFeature((a, s) -> s.enable((DamageState)ArcheryDamageState.BYPASS_INVUL), () -> LangData.FEATURE_PIERCE_INVUL.get(new Object[0])))).lang("Sight of the Void (Creative Only)").register();
        SUN_BOW = ArcheryItems.genBow("sun_bow", 3, 600, e -> e.add((Object)new FireArrowFeature(200)).add((Object)new ExplodeArrowFeature(4.0f, true, false))).lang("Bless of Helios").register();
        STARTER_ARROW = ArcheryItems.genArrow("starter_arrow", 2);
        COPPER_ARROW = ArcheryItems.genArrow("copper_arrow", 1);
        IRON_ARROW = ArcheryItems.genArrow("iron_arrow", 1);
        GOLD_ARROW = ArcheryItems.genArrow("gold_arrow", 1);
        OBSIDIAN_ARROW = ArcheryItems.genArrow("obsidian_arrow", 1);
        BLACKSTONE_ARROW = ArcheryItems.genArrow("blackstone_arrow", 1);
        QUARTZ_ARROW = ArcheryItems.genArrow("quartz_arrow", 1);
        DIAMOND_ARROW = ArcheryItems.genArrow("diamond_arrow", 1);
        DESTROYER_ARROW = ArcheryItems.genArrow("destroyer_arrow", 0);
        TOTEMIC_GOLD_ARROW = ArcheryItems.genArrow("totemic_gold_arrow", 0, e -> e.add((Object)new DamageModifierArrowFeature((a, s) -> LCMats.TOTEMIC_GOLD.getExtraToolConfig().onDamage(s, ItemStack.EMPTY), list -> LCMats.TOTEMIC_GOLD.getExtraToolConfig().addTooltip(ItemStack.EMPTY, list))).add((Object)new TotemicArrowFeature(4))).register();
        POSEIDITE_ARROW = ArcheryItems.genArrow("poseidite_arrow", 0, e -> e.add((Object)new DamageModifierArrowFeature((a, s) -> {
            LCMats.POSEIDITE.getExtraToolConfig().onDamage(s, ItemStack.EMPTY);
            if (a.isInWaterRainOrBubble()) {
                s.addHurtModifier(DamageModifier.multAttr((float)1.5f, (ResourceLocation)L2Archery.loc("poseidite_arrow")));
            }
        }, list -> LCMats.POSEIDITE.getExtraToolConfig().addTooltip(ItemStack.EMPTY, list))).add((Object)new PoseiditeArrowFeature())).register();
        SHULKERATE_ARROW = ArcheryItems.genArrow("shulkerate_arrow", 0, e -> e.add((Object)new NoFallArrowFeature(40))).register();
        SCULKIUM_ARROW = ArcheryItems.genArrow("sculkium_arrow", 0, e -> e.add((Object)new DamageSourceArrowFeature((a, s) -> {
            s.enable((DamageState)DefaultDamageState.BYPASS_MAGIC);
            s.enable((DamageState)DefaultDamageState.BYPASS_ARMOR);
        }, () -> LangData.FEATURE_PIERCE_BOTH.get(new Object[0])))).register();
        ETERNIUM_ARROW = ArcheryItems.genArrow("eternium_arrow", 2);
        TEARING_ARROW = ArcheryItems.genArrow("tearing_arrow", 0, e -> e.add((Object)new BleedingArrowFeature(100, 9))).register();
        NO_FALL_ARROW = ArcheryItems.genArrow("no_fall_arrow", 1, e -> e.add((Object)new NoFallArrowFeature(40))).lang("Anti-Gravity Arrow").register();
        ENDER_ARROW = ArcheryItems.genArrow("ender_arrow", 0, e -> e.add((Object)new EnderArrowFeature())).register();
        TNT_1_ARROW = ArcheryItems.genArrow("tnt_arrow_lv1", 1, e -> e.add((Object)new ExplodeArrowFeature(2.0f, true, false))).lang("Explosion Arrow").register();
        TNT_2_ARROW = ArcheryItems.genArrow("tnt_arrow_lv2", 0, e -> e.add((Object)new ExplodeArrowFeature(4.0f, true, false))).lang("TNT Arrow").register();
        TNT_3_ARROW = ArcheryItems.genArrow("tnt_arrow_lv3", 0, e -> e.add((Object)new ExplodeArrowFeature(6.0f, true, false))).lang("End Crystal Arrow").register();
        FIRE_1_ARROW = ArcheryItems.genArrow("fire_arrow_lv1", 1, e -> e.add((Object)new FireArrowFeature(100))).lang("Soul Fire Arrow").register();
        FIRE_2_ARROW = ArcheryItems.genArrow("fire_arrow_lv2", 0, e -> e.add((Object)new FireArrowFeature(200))).lang("Cursed Fire Arrow").register();
        ICE_ARROW = ArcheryItems.genArrow("frozen_arrow", 1);
        ACID_ARROW = ArcheryItems.genArrow("acid_arrow", 1);
        DISPELL_ARROW = ArcheryItems.genArrow("dispell_arrow", 0, e -> e.add((Object)new DamageSourceArrowFeature((a, s) -> s.enable((DamageState)DefaultDamageState.BYPASS_MAGIC), () -> LangData.FEATURE_PIERCE_MAGIC.get(new Object[0])))).register();
        WITHER_ARROW = ArcheryItems.genArrow("wither_arrow", 1, e -> e.add((Object)new DamageSourceArrowFeature((a, s) -> s.enable((DamageState)DefaultDamageState.BYPASS_ARMOR), () -> LangData.FEATURE_PIERCE_ARMOR.get(new Object[0])))).register();
        STORM_ARROW = ArcheryItems.genArrow("storm_arrow", 1, e -> e.add((Object)new ExplodeArrowFeature(3.0f, false, false))).register();
        VOID_ARROW = ArcheryItems.genArrow("void_arrow", 0, e -> e.add((Object)new DamageSourceArrowFeature((a, s) -> s.enable((DamageState)ArcheryDamageState.BYPASS_INVUL), () -> LangData.FEATURE_PIERCE_INVUL.get(new Object[0]))).add((Object)new VoidArrowFeature())).lang("Void Arrow (Creative Only)").register();
        UPGRADE = L2Archery.REGISTRATE.item("upgrade", UpgradeItem::new).defaultModel().defaultLang().tab(TAB.getKey(), e -> ((UpgradeItem)((Object)((Object)UPGRADE.get()))).fillItemCategory((CreativeModeTabModifier)e)).register();
        MAGNIFY_UP_1 = ArcheryItems.genUpgrade("magnify_x2", () -> new StatFeature(2.0f, 10, 1.0f, 0, 1.0f));
        MAGNIFY_UP_2 = ArcheryItems.genUpgrade("magnify_x4", () -> new StatFeature(4.0f, 30, 1.0f, 0, 1.0f));
        MAGNIFY_UP_3 = ArcheryItems.genUpgrade("magnify_x8", () -> new StatFeature(8.0f, 50, 1.0f, 0, 1.0f));
        DAMAGE_UP = ArcheryItems.genUpgrade("damage", () -> new StatFeature(1.0f, 0, 2.0f, 0, 1.0f));
        SUPERDAMAGE_UP = ArcheryItems.genUpgrade("super_damage", () -> new StatFeature(1.0f, 0, 3.0f, 0, 1.0f));
        PUNCH_UP = ArcheryItems.genUpgrade("punch", () -> new StatFeature(1.0f, 0, 1.0f, 3, 1.0f));
        GLOW_UP = ArcheryItems.genUpgrade("glow", () -> new GlowTargetAimFeature(128));
        NO_FALL_UP = ArcheryItems.genUpgrade("anti_gravity", () -> new NoFallArrowFeature(40));
        EXPLOSION_UP = ArcheryItems.genUpgrade("explosion", () -> new ExplodeArrowFeature(3.0f, true, false));
        ENDER_UP = ArcheryItems.genUpgrade("void", () -> new EnderShootFeature(128));
        RAILGUN_UP = ArcheryItems.genUpgrade("railgun", () -> new StatFeature(1.0f, 1, 1.0f, 0, 100.0f));
        FLUX_UP = ArcheryItems.genUpgrade("flux_up", () -> FluxFeature.DEFAULT);
        DOUBLE_CHARGE = ArcheryItems.genUpgrade("double_charge", () -> new DoubleChargeFeature(2.0));
        ADVANCED_INFINITY = ArcheryItems.genUpgrade("advanced_infinity", () -> new InfinityFeature(2));
        EXPLOSION_BREAKER = ArcheryItems.genUpgrade("explosion_breaker", () -> ExplosionBreakFeature.INS);
        FIRE_UP = ArcheryItems.genPotionUpgrade("soul_fire");
        ICE_UP = ArcheryItems.genPotionUpgrade("frozen");
        BLACKSTONE_UP = ArcheryItems.genPotionUpgrade("blackstone");
        HARM_UP = ArcheryItems.genPotionUpgrade("harm");
        HEAL_UP = ArcheryItems.genPotionUpgrade("heal");
        SHINE_UP = ArcheryItems.genPotionUpgrade("glowing");
        LEVITATE_UP = ArcheryItems.genPotionUpgrade("levitate");
        FLOAT_UP = ArcheryItems.genPotionUpgrade("levitation");
        SLOW_UP = ArcheryItems.genPotionUpgrade("slowness");
        POISON_UP = ArcheryItems.genPotionUpgrade("poison");
        WITHER_UP = ArcheryItems.genPotionUpgrade("wither");
        WEAK_UP = ArcheryItems.genPotionUpgrade("weak");
        CORROSION_UP = ArcheryItems.genPotionUpgrade("corrosion");
        CURSE_UP = ArcheryItems.genPotionUpgrade("curse");
        CLEANSE_UP = ArcheryItems.genPotionUpgrade("cleanse");
        BOW_PULL_VALS = new float[]{0.0f, 0.65f, 0.9f};
    }
}

