/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.init.registrate;

import dev.xkmc.l2archery.content.enchantment.BaseBowEnchantment;
import dev.xkmc.l2archery.content.enchantment.GenericBowEnchantment;
import dev.xkmc.l2archery.content.enchantment.PotionArrowEnchantment;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.ExplodeArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.ExplosionBreakFeature;
import dev.xkmc.l2archery.content.feature.bow.GlowTargetAimFeature;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.init.L2Archery;
import dev.xkmc.l2archery.init.data.ArcheryTagGen;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2core.init.reg.ench.EnchColor;
import dev.xkmc.l2core.init.reg.ench.EnchReg;
import dev.xkmc.l2core.init.reg.ench.EnchVal;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;

public class ArcheryEnchantments {
    private static final EnchReg REG = EnchReg.of((Reg)L2Archery.REG, (L2Registrate)L2Archery.REGISTRATE);
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_GLOW;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_HARM;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_HEAL;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_FLOAT;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_SLOW;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_LEVITATE;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_POISON;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_WITHER;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_WEAK;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_CHAOTIC;
    public static final EnchVal.Legacy<PotionArrowEnchantment> ENCH_DISTORTION;
    public static final EnchVal.Legacy<GenericBowEnchantment> ENCH_MAGNIFY;
    public static final EnchVal.Legacy<GenericBowEnchantment> ENCH_EXPLODE;
    public static final EnchVal.Legacy<GenericBowEnchantment> ENCH_GLOW_AIM;
    public static final EnchVal.Legacy<GenericBowEnchantment> ENCH_EXPLOSION_BREAK;
    private static final LCEnchantments.Order ORDER;

    public static <T extends BaseBowEnchantment> EnchVal.Legacy<T> reg(String id, int max, String def, Supplier<T> sup, String desc) {
        return REG.enchLegacy(id, def, desc, b -> b.items(ArcheryTagGen.PROF_BOWS).maxLevel(max).color(new EnchColor(ChatFormatting.GREEN, ChatFormatting.GRAY)).special(LCEnchantments.CRAFT, (Object)ORDER.of(-32769)), sup);
    }

    public static EnchVal.Legacy<GenericBowEnchantment> regStat(String id, int max, String def, Function<Integer, BowArrowFeature> func, String desc) {
        return ArcheryEnchantments.reg(id, max, def, () -> new GenericBowEnchantment(max, func), desc);
    }

    public static EnchVal.Legacy<PotionArrowEnchantment> regPotion(String id, int max, String def, String desc) {
        return ArcheryEnchantments.reg(id, max, def, PotionArrowEnchantment::new, desc + " Works only on L2Archery Bows.");
    }

    public static void register() {
    }

    static {
        ORDER = new LCEnchantments.Order();
        ENCH_MAGNIFY = ArcheryEnchantments.regStat("magnify", 3, "Archery - Magnify Upgrade", i -> new StatFeature(1 << i, i * 20 - 10, 1.0f, 0, 1.0f), "Zoom in when pulling bow. Works only on L2Archery Bows.");
        ENCH_GLOW_AIM = ArcheryEnchantments.regStat("glow_aim", 1, "Archery - Glow Aiming Upgrade", i -> new GlowTargetAimFeature(128), "Aimed entity will appear glowing. Works only on L2Archery Bows.");
        ENCH_EXPLODE = ArcheryEnchantments.regStat("explode", 3, "Archery - Explosion Upgrade", i -> new ExplodeArrowFeature(i.intValue(), false, false), "Create explosion on hit. It will not break block or hurt entities. Works only on L2Archery Bows.");
        ENCH_EXPLOSION_BREAK = ArcheryEnchantments.regStat("explosion_break", 1, "Archery - Explosion Breaking", i -> ExplosionBreakFeature.INS, "Explosion will break blocks anyway.");
        ENCH_GLOW = ArcheryEnchantments.regPotion("glow", 1, "Archery - Glow Upgrade", "Make enemy glow on hit.");
        ENCH_HARM = ArcheryEnchantments.regPotion("harm", 3, "Archery - Instant Damage Upgrade", "Inflict enemy with Instant Damage on hit.");
        ENCH_HEAL = ArcheryEnchantments.regPotion("heal", 3, "Archery - Instant Heal Upgrade", "Inflict enemy with Instant Heal on hit.");
        ENCH_FLOAT = ArcheryEnchantments.regPotion("float", 5, "Archery - Feather Falling Upgrade", "Apply Feather Falling to enemy on hit.");
        ENCH_SLOW = ArcheryEnchantments.regPotion("slow", 5, "Archery - Slow Upgrade", "Apply Slowness to enemy on hit.");
        ENCH_LEVITATE = ArcheryEnchantments.regPotion("levitate", 5, "Archery - Levitation Upgrade", "Apply Levitation to enemy on hit.");
        ENCH_POISON = ArcheryEnchantments.regPotion("poison", 3, "Archery - Poison Upgrade", "Inflict enemy with Poison on hit.");
        ENCH_WITHER = ArcheryEnchantments.regPotion("wither", 3, "Archery - Wither Upgrade", "Inflict enemy with Wither on hit.");
        ENCH_WEAK = ArcheryEnchantments.regPotion("weak", 5, "Archery - Weak Upgrade", "Inflict enemy with Weakness on hit.");
        ENCH_CHAOTIC = ArcheryEnchantments.regPotion("chaotic", 3, "Archery - Chaotic Upgrade", "Inflict enemy with various beneficial and harmful effects.");
        ENCH_DISTORTION = ArcheryEnchantments.regPotion("distortion", 3, "Archery - Distortion Upgrade", "Inflict enemy with various visual-only effects.");
    }
}

