/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.init;

import com.tterrag.registrate.providers.DataProviderInitializer;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.l2archery.content.energy.EnergyContainerItemWrapper;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.events.ArrowAttackListener;
import dev.xkmc.l2archery.init.data.AdvGen;
import dev.xkmc.l2archery.init.data.ArcheryConfig;
import dev.xkmc.l2archery.init.data.ArcheryConfigGen;
import dev.xkmc.l2archery.init.data.ArcheryDamageMultiplex;
import dev.xkmc.l2archery.init.data.ArcheryTagGen;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.data.RecipeGen;
import dev.xkmc.l2archery.init.registrate.ArcheryEffects;
import dev.xkmc.l2archery.init.registrate.ArcheryEnchantments;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import dev.xkmc.l2core.init.L2TagGen;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2core.serial.config.PacketHandlerWithConfig;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2serial.serialization.custom_handler.CodecHandler;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="l2archery")
@EventBusSubscriber(modid="l2archery", bus=EventBusSubscriber.Bus.MOD)
public class L2Archery {
    public static final String MODID = "l2archery";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Reg REG = new Reg("l2archery");
    public static final L2Registrate REGISTRATE = new L2Registrate("l2archery");
    public static final PacketHandlerWithConfig HANDLER = new PacketHandlerWithConfig("l2archery", 2, new Function[0]);

    public L2Archery() {
        ArcheryRegister.register();
        ArcheryItems.register();
        ArcheryEffects.register();
        ArcheryEnchantments.register();
        ArcheryDamageMultiplex.register();
        AttackEventHandler.register((int)2000, (AttackListener)new ArrowAttackListener());
        ArcheryConfig.init();
        new CodecHandler(PotionContents.class, PotionContents.CODEC, PotionContents.STREAM_CODEC);
        new CodecHandler(ItemEnchantments.class, ItemEnchantments.CODEC, ItemEnchantments.STREAM_CODEC);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::genLang);
        REGISTRATE.addDataGenerator(ProviderType.ADVANCEMENT, AdvGen::genAdvancements);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, ArcheryTagGen::genItemTag);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, ArcheryTagGen::onEntityTagGen);
        REGISTRATE.addDataGenerator(L2TagGen.EFF_TAGS, ArcheryTagGen::onEffectTagGen);
        REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, ArcheryConfigGen::onDataMapGen);
        DataProviderInitializer init = REGISTRATE.getDataGenInitializer();
        init.addDependency(ProviderType.RECIPE, ProviderType.DYNAMIC);
        new ArcheryDamageMultiplex().generate();
    }

    @SubscribeEvent
    public static void registerCaps(RegisterCapabilitiesEvent event) {
        for (GenericBowItem e : ArcheryItems.BOW_LIKE) {
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, x) -> new EnergyContainerItemWrapper((ItemStack)stack, e), new ItemLike[]{e});
        }
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

