/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.events;

import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.upgrade.BowUpgrade;
import dev.xkmc.l2archery.content.upgrade.StatHolder;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.content.upgrade.UpgradeItem;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.GrindstoneEvent;

@EventBusSubscriber(modid="l2archery", bus=EventBusSubscriber.Bus.GAME)
public class ArcheryEventHandler {
    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        Item item = left.getItem();
        if (item instanceof GenericBowItem) {
            GenericBowItem bow = (GenericBowItem)item;
            if (right.getItem() instanceof UpgradeItem) {
                Upgrade upgrade = UpgradeItem.getUpgrade(right);
                if (upgrade == null) {
                    return;
                }
                if (!ArcheryEventHandler.allowUpgrade(bow, left, upgrade)) {
                    return;
                }
                int count = GenericBowItem.getUpgrades(left).size();
                ItemStack result = left.copy();
                GenericBowItem.addUpgrade(result, upgrade);
                GenericBowItem.remakeEnergy(result);
                event.setOutput(result);
                event.setMaterialCost(1);
                event.setCost(8L << count);
            }
        }
    }

    public static boolean allowUpgrade(GenericBowItem bow, ItemStack bowStack, Upgrade upgrade) {
        FeatureList list = bow.getFeatures(bowStack);
        if (!upgrade.allow(bow)) {
            return false;
        }
        int remain = bow.getUpgradeSlot(bowStack);
        if (remain <= 0) {
            return false;
        }
        if (!list.allow(upgrade.getFeature())) {
            return false;
        }
        BowArrowFeature bowArrowFeature = upgrade.getFeature();
        if (bowArrowFeature instanceof StatFeature) {
            StatFeature stat = (StatFeature)bowArrowFeature;
            List<Upgrade> ups = GenericBowItem.getUpgrades(bowStack);
            TreeSet<StatHolder> set = new TreeSet<StatHolder>();
            for (Upgrade up : ups) {
                BowArrowFeature bowArrowFeature2 = up.getFeature();
                if (!(bowArrowFeature2 instanceof StatFeature)) continue;
                StatFeature f = (StatFeature)bowArrowFeature2;
                f.addStatHolder(set);
            }
            return stat.addStatHolder(set);
        }
        return true;
    }

    @SubscribeEvent
    public static void onGrind(GrindstoneEvent.OnPlaceItem event) {
        Item item = event.getTopItem().getItem();
        if (item instanceof GenericBowItem) {
            GenericBowItem bow = (GenericBowItem)item;
            ItemStack copy = event.getTopItem().copy();
            BowUpgrade upgrades = (BowUpgrade)ArcheryItems.BOW_UPGRADE.get(copy);
            if (upgrades != null && !upgrades.list().isEmpty()) {
                ArcheryItems.BOW_UPGRADE.set(copy, (Object)upgrades.clear());
                GenericBowItem.remakeEnergy(copy);
                event.setOutput(copy);
                event.setXp(0);
            }
        }
    }
}

