/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.events;

import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.init.registrate.ArcheryEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="l2archery", bus=EventBusSubscriber.Bus.GAME)
public class ArcheryClientEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void fov(ComputeFovModifierEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof GenericBowItem) {
            GenericBowItem bow = (GenericBowItem)item;
            float fov = event.getFovModifier();
            float i = player.getTicksUsingItem();
            MobEffectInstance ins = player.getEffect(ArcheryEffects.QUICK_PULL);
            if (ins != null) {
                i *= 1.5f + 0.5f * (float)ins.getAmplifier();
            }
            BowData data = BowData.of(bow, stack);
            float time = data.getConfig().fovTime();
            float factor = 1.0f - Math.min(1.0f, i / time) * data.getConfig().fov();
            double scale = (Double)Minecraft.getInstance().options.fovEffectScale().get();
            event.setNewFovModifier((float)Mth.lerp((double)scale, (double)1.0, (double)(fov * factor)));
        }
    }
}

