/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.upgrade;

import com.tterrag.registrate.util.CreativeModeTabModifier;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.upgrade.StatHolder;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class UpgradeItem
extends Item {
    private static final String KEY = "upgrade";

    @Nullable
    public static Upgrade getUpgrade(ItemStack stack) {
        return (Upgrade)((Object)ArcheryItems.ITEM_UPGRADE.get(stack));
    }

    public static ItemStack setUpgrade(ItemStack stack, Upgrade upgrade) {
        return ArcheryItems.ITEM_UPGRADE.set(stack, (Object)upgrade);
    }

    public UpgradeItem(Item.Properties props) {
        super(props);
    }

    public void fillItemCategory(CreativeModeTabModifier tab) {
        tab.accept(new ItemStack((ItemLike)this));
        for (Upgrade upgrade : ArcheryRegister.UPGRADE.get().stream().toList()) {
            tab.accept(UpgradeItem.setUpgrade(new ItemStack((ItemLike)this), upgrade));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return UpgradeItem.getUpgrade(stack) != null;
    }

    public Component getName(ItemStack stack) {
        Upgrade upgrade = UpgradeItem.getUpgrade(stack);
        if (upgrade != null) {
            return Component.translatable((String)upgrade.getDescriptionId());
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        Upgrade upgrade = UpgradeItem.getUpgrade(stack);
        if (upgrade != null) {
            StatFeature stat;
            BowArrowFeature bowArrowFeature = upgrade.getFeature();
            if (bowArrowFeature instanceof PotionArrowFeature) {
                PotionArrowFeature arr = (PotionArrowFeature)bowArrowFeature;
                PotionArrowFeature.addTooltip(arr.instances(), list);
            }
            ArrayList<MutableComponent> temp = new ArrayList<MutableComponent>();
            upgrade.getFeature().addTooltip(temp);
            for (MutableComponent c : temp) {
                if (c.getStyle().getColor() == null) {
                    c.withStyle(ChatFormatting.GOLD);
                }
                list.add((Component)c);
            }
            BowArrowFeature bowArrowFeature2 = upgrade.getFeature();
            if (bowArrowFeature2 instanceof StatFeature && !(stat = (StatFeature)bowArrowFeature2).addStatHolder(new HashSet<StatHolder>(Set.of(StatHolder.DAMAGE)))) {
                list.add((Component)LangData.DAMAGE_UPGRADE.get(new Object[0]));
            }
        }
    }
}

