/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.controller.ArrowFeatureController;
import dev.xkmc.l2archery.content.controller.BowFeatureController;
import dev.xkmc.l2archery.content.enchantment.IBowEnchantment;
import dev.xkmc.l2archery.content.energy.IFluxItem;
import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.bow.FluxFeature;
import dev.xkmc.l2archery.content.feature.bow.IGlowFeature;
import dev.xkmc.l2archery.content.feature.bow.WindBowFeature;
import dev.xkmc.l2archery.content.feature.core.CompoundBowConfig;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.item.ArrowData;
import dev.xkmc.l2archery.content.item.BowConfig;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.content.item.IBowConfig;
import dev.xkmc.l2archery.content.upgrade.BowUpgrade;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.registrate.ArcheryEffects;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import dev.xkmc.l2core.init.reg.ench.EnchHelper;
import dev.xkmc.l2core.init.reg.ench.EnchHolder;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import dev.xkmc.l2library.content.raytrace.FastItem;
import dev.xkmc.l2library.content.raytrace.IGlowingTarget;
import dev.xkmc.l2library.util.GenericItemStack;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class GenericBowItem
extends BowItem
implements FastItem,
IGlowingTarget,
IFluxItem {
    public final BowConfig config;

    public static List<Upgrade> getUpgrades(ItemStack stack) {
        return ((BowUpgrade)ArcheryItems.BOW_UPGRADE.getOrDefault(stack, (Object)BowUpgrade.DEF)).list();
    }

    public static void addUpgrade(ItemStack result, Upgrade upgrade) {
        BowUpgrade current = (BowUpgrade)ArcheryItems.BOW_UPGRADE.getOrDefault(result, (Object)BowUpgrade.DEF);
        ArcheryItems.BOW_UPGRADE.set(result, (Object)current.add(upgrade));
    }

    public GenericBowItem(Item.Properties properties, Function<GenericBowItem, BowConfig> config) {
        super(properties);
        this.config = config.apply(this);
        ArcheryItems.BOW_LIKE.add(this);
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        float speed = this.config.speed();
        if (projectile instanceof GenericArrowEntity) {
            GenericArrowEntity e = (GenericArrowEntity)projectile;
            speed = e.data.bow().getConfig().speed();
        }
        super.shootProjectile(shooter, projectile, index, velocity * speed / 3.0f, 0.0f, angle, target);
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack arrow, boolean isCrit) {
        AbstractArrow ans;
        ArrowData data = this.parseArrow(arrow);
        if (data != null && (ans = ArrowFeatureController.createArrowEntity(new ArrowFeatureController.BowArrowUseContext(level, shooter), BowData.of(this, weapon), data, arrow, weapon)) != null) {
            return ans;
        }
        return super.createProjectile(level, shooter, weapon, arrow, isCrit);
    }

    public float getRawPowerForTime(LivingEntity entity, float time) {
        float f = time / (float)this.config.pullTime();
        MobEffectInstance ins = entity.getEffect(ArcheryEffects.QUICK_PULL);
        if (ins != null) {
            f *= 1.5f + 0.5f * (float)ins.getAmplifier();
        }
        return f;
    }

    public float getPullForTime(LivingEntity entity, float time) {
        return Math.min(1.0f, this.getRawPowerForTime(entity, time));
    }

    public float getPowerForTime(LivingEntity entity, float time) {
        float f = this.getPullForTime(entity, time);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return Math.min(1.0f, f);
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int count) {
        if (user instanceof Player) {
            Player player = (Player)user;
            BowFeatureController.usingTick((LivingEntity)player, (GenericItemStack<GenericBowItem>)new GenericItemStack((Item)this, stack));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder ans = super.use(level, player, hand);
        if (player.isUsingItem()) {
            BowFeatureController.startUsing((LivingEntity)player, (GenericItemStack<GenericBowItem>)new GenericItemStack((Item)this, player.getItemInHand(hand)));
        }
        return ans;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        Player player;
        ItemStack itemstack;
        if (entityLiving instanceof Player && !(itemstack = (player = (Player)entityLiving).getProjectile(stack)).isEmpty()) {
            int i = this.getUseDuration(stack, entityLiving) - timeLeft;
            if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                return;
            }
            float f = this.getPowerForTime((LivingEntity)player, i);
            if (!((double)f < 0.1)) {
                List list = GenericBowItem.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 3.0f, 1.0f, f == 1.0f, null);
                    }
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> {
            if (stack.is(Items.ARROW) || stack.is(Items.SPECTRAL_ARROW) || stack.is(Items.TIPPED_ARROW)) {
                return true;
            }
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof GenericArrowItem) {
                GenericArrowItem arrow = (GenericArrowItem)patt0$temp;
                return ArrowFeatureController.canBowUseArrow(this, (GenericItemStack<GenericArrowItem>)new GenericItemStack((Item)arrow, stack));
            }
            return false;
        };
    }

    @Nullable
    public ArrowData parseArrow(ItemStack arrow) {
        ArrowData data = null;
        Item item = arrow.getItem();
        if (item instanceof GenericArrowItem) {
            GenericArrowItem gen = (GenericArrowItem)item;
            data = ArrowData.of((Item)gen);
        } else if (arrow.is(Items.ARROW)) {
            data = ArrowData.of(arrow.getItem());
        } else if (arrow.is(Items.SPECTRAL_ARROW)) {
            data = ArrowData.of(arrow.getItem());
        } else if (arrow.is(Items.TIPPED_ARROW)) {
            data = ArrowData.of(arrow.getItem(), (PotionContents)arrow.get(DataComponents.POTION_CONTENTS));
        }
        return data;
    }

    public int getDefaultProjectileRange() {
        return 30;
    }

    public boolean isFast(ItemStack stack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.hasEffect(ArcheryEffects.RUN_BOW)) {
            return true;
        }
        return this.config.feature().stream().anyMatch(e -> e instanceof WindBowFeature);
    }

    public int getDistance(ItemStack itemStack) {
        for (BowArrowFeature feature : this.getFeatures(itemStack).all()) {
            if (!(feature instanceof IGlowFeature)) continue;
            IGlowFeature glow = (IGlowFeature)((Object)feature);
            return glow.range();
        }
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        List<Upgrade> ups = GenericBowItem.getUpgrades(stack);
        Record config = this.config;
        for (Upgrade up : ups) {
            BowArrowFeature bowArrowFeature = up.getFeature();
            if (!(bowArrowFeature instanceof StatFeature)) continue;
            StatFeature f = (StatFeature)bowArrowFeature;
            config = new CompoundBowConfig((IBowConfig)((Object)config), f);
        }
        config.addStatTooltip(list);
        for (Upgrade up : ups) {
            list.add((Component)Component.translatable((String)up.getDescriptionId()).withStyle(ChatFormatting.GOLD));
        }
        FeatureList f = this.getFeatures(stack);
        f.addEffectsTooltip(list);
        f.addTooltip(list);
        this.tooltipDelegate(stack, list);
        list.add((Component)LangData.REMAIN_UPGRADE.get(this.getUpgradeSlot(stack)));
    }

    public FeatureList getFeatures(@Nullable ItemStack stack) {
        FeatureList ans = new FeatureList();
        PotionArrowFeature bow_eff = this.config.getEffects();
        if (!bow_eff.instances().isEmpty()) {
            ans.add(bow_eff);
        }
        for (BowArrowFeature feature : this.config.feature()) {
            ans.add(feature);
        }
        if (stack != null) {
            BowArrowFeature f;
            ans.stage = FeatureList.Stage.UPGRADE;
            for (Upgrade up : GenericBowItem.getUpgrades(stack)) {
                f = up.getFeature();
                if (f instanceof StatFeature) continue;
                ans.add(f);
            }
            ans.stage = FeatureList.Stage.ENCHANT;
            for (EnchHolder e : LegacyEnchantment.findAll((ItemStack)stack, IBowEnchantment.class, (boolean)true)) {
                f = ((IBowEnchantment)e.val()).getFeature(e.lv());
                if (f instanceof StatFeature) continue;
                ans.add(f);
            }
        }
        return ans;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.BINDING_CURSE)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public int getUpgradeSlot(ItemStack stack) {
        BowUpgrade upgrades = (BowUpgrade)ArcheryItems.BOW_UPGRADE.getOrDefault(stack, (Object)BowUpgrade.DEF);
        return this.config.rank() + EnchHelper.getLv((ItemStack)stack, (ResourceKey)Enchantments.BINDING_CURSE) + upgrades.additional() - GenericBowItem.getUpgrades(stack).size();
    }

    public static void remakeEnergy(ItemStack stack) {
        stack.remove(ArcheryItems.ENERGY);
    }

    @Override
    @Nullable
    public FluxFeature getFluxFeature(ItemStack stack) {
        for (Upgrade upgrade : GenericBowItem.getUpgrades(stack)) {
            BowArrowFeature bowArrowFeature = upgrade.getFeature();
            if (!(bowArrowFeature instanceof FluxFeature)) continue;
            FluxFeature ff = (FluxFeature)bowArrowFeature;
            return ff;
        }
        return null;
    }

    @Override
    public int getStorageRank(ItemStack stack) {
        return this.config.rank();
    }

    @Override
    public int getConsumptionRank(ItemStack stack) {
        return this.config.rank() + Math.min(4, GenericBowItem.getUpgrades(stack).size());
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getFluxFeature(stack) != null || super.isBarVisible(stack);
    }
}

