/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.controller.ArrowFeatureController;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.bow.InfinityFeature;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.item.ArrowConfig;
import dev.xkmc.l2archery.content.item.ArrowData;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.item.IGeneralConfig;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import dev.xkmc.l2core.init.reg.ench.EnchHelper;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GenericArrowItem
extends ArrowItem {
    private final ArrowConfig config;

    public GenericArrowItem(Item.Properties properties, Function<GenericArrowItem, ArrowConfig> config) {
        super(properties);
        this.config = config.apply(this);
    }

    public AbstractArrow createArrow(Level level, ItemStack stack, LivingEntity user, @Nullable ItemStack bow) {
        BowData bowData;
        Item item;
        if (bow == null) {
            bow = user.getItemInHand(user.getUsedItemHand());
        }
        if ((item = bow.getItem()) instanceof GenericBowItem) {
            GenericBowItem bowItem = (GenericBowItem)item;
            bowData = BowData.of(bowItem, bow);
        } else {
            bowData = BowData.of((GenericBowItem)ArcheryItems.STARTER_BOW.get(), bow);
        }
        BowData bowData2 = bowData;
        AbstractArrow arrow = ArrowFeatureController.createArrowEntity(new ArrowFeatureController.BowArrowUseContext(level, user), bowData2, ArrowData.of((Item)this), stack.copyWithCount(1), bow);
        if (arrow == null) {
            arrow = new Arrow(level, user, stack.copyWithCount(1), bow);
        }
        return arrow;
    }

    public boolean isInfinite(ItemStack ammo, ItemStack bow, LivingEntity player) {
        int enchant = EnchHelper.getLv((ItemStack)bow, (ResourceKey)Enchantments.INFINITY);
        int infLevel = enchant > 0 ? 1 : 0;
        Item item = bow.getItem();
        if (item instanceof GenericBowItem) {
            GenericBowItem bowItem = (GenericBowItem)item;
            infLevel = Math.max(InfinityFeature.getLevel(bowItem.getFeatures(bow)), infLevel);
        }
        if (this.config.infLevel() > 0) {
            return infLevel + this.config.infLevel() >= 3 || super.isInfinite(ammo, bow, player);
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        this.config.addTooltip(list);
        this.getFeatures().addTooltip(list);
    }

    public FeatureList getFeatures() {
        FeatureList list = new FeatureList();
        PotionArrowFeature arrow_eff = this.config.getEffects();
        if (!arrow_eff.instances().isEmpty()) {
            list.add(arrow_eff);
        }
        for (BowArrowFeature feature : this.config.feature()) {
            list.add(feature);
        }
        return list;
    }

    public IGeneralConfig getConfig() {
        return this.config;
    }
}

