/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.enchantment.IBowEnchantment;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.core.CompoundBowConfig;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.item.IBowConfig;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.CommonHooks;

public record BowData(Item item, ArrayList<Upgrade> upgrade, ItemEnchantments ench) {
    public static BowData of(GenericBowItem item) {
        return new BowData((Item)item, new ArrayList<Upgrade>(0), ItemEnchantments.EMPTY);
    }

    public static BowData of(GenericBowItem item, List<Upgrade> upgrade, ItemEnchantments ench) {
        return new BowData((Item)item, new ArrayList<Upgrade>(upgrade), ench);
    }

    public static BowData of(GenericBowItem item, ItemStack stack) {
        List<Upgrade> upgrade = GenericBowItem.getUpgrades(stack);
        HolderLookup.RegistryLookup reg = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        return BowData.of(item, upgrade, reg == null ? ItemEnchantments.EMPTY : stack.getAllEnchantments(reg));
    }

    public FeatureList getFeatures() {
        FeatureList ans = this.getItem().getFeatures(null);
        ans.stage = FeatureList.Stage.UPGRADE;
        this.upgrade.forEach(e -> ans.add(e.getFeature()));
        ans.stage = FeatureList.Stage.ENCHANT;
        for (Object2IntMap.Entry e2 : this.ench.entrySet()) {
            IBowEnchantment legacy = (IBowEnchantment)LegacyEnchantment.firstOf((Holder)((Holder)e2.getKey()), IBowEnchantment.class);
            if (legacy == null) continue;
            ans.add(legacy.getFeature(e2.getIntValue()));
        }
        return ans;
    }

    public GenericBowItem getItem() {
        return (GenericBowItem)this.item;
    }

    public IBowConfig getConfig() {
        Record ans = this.getItem().config;
        for (Upgrade up : this.upgrade) {
            BowArrowFeature bowArrowFeature = up.getFeature();
            if (!(bowArrowFeature instanceof StatFeature)) continue;
            StatFeature f = (StatFeature)bowArrowFeature;
            ans = new CompoundBowConfig((IBowConfig)((Object)ans), f);
        }
        for (Object2IntMap.Entry e : this.ench.entrySet()) {
            BowArrowFeature f;
            IBowEnchantment legacy = (IBowEnchantment)LegacyEnchantment.firstOf((Holder)((Holder)e.getKey()), IBowEnchantment.class);
            if (legacy == null || !((f = legacy.getFeature(e.getIntValue())) instanceof StatFeature)) continue;
            StatFeature sf = (StatFeature)f;
            ans = new CompoundBowConfig((IBowConfig)((Object)ans), sf);
        }
        return ans;
    }
}

