/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpectralArrowItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;

public record ArrowData(Item item, @Nullable PotionContents custom) {
    public static ArrowData of(Item item) {
        return new ArrowData(item, null);
    }

    public static ArrowData of(Item item, @Nullable PotionContents custom) {
        return new ArrowData(item, custom);
    }

    public FeatureList getFeatures() {
        Item item = this.item;
        if (item instanceof GenericArrowItem) {
            GenericArrowItem gen = (GenericArrowItem)item;
            return gen.getFeatures();
        }
        FeatureList ans = new FeatureList();
        if (this.item instanceof SpectralArrowItem) {
            ans.add(new PotionArrowFeature(List.of(new MobEffectInstance(MobEffects.GLOWING, 200, 0))));
        } else if (this.item instanceof TippedArrowItem && this.custom != null) {
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
            for (MobEffectInstance ins : this.custom.getAllEffects()) {
                list.add(new MobEffectInstance(ins.getEffect(), Math.max(ins.getDuration() / 8, 1), ins.getAmplifier(), ins.isAmbient(), ins.isVisible()));
            }
            ans.add(new PotionArrowFeature(list));
        }
        return ans;
    }

    public ItemStack stack() {
        if (this.item instanceof TippedArrowItem) {
            ItemStack ans = new ItemStack((ItemLike)this.item);
            ans.set(DataComponents.POTION_CONTENTS, (Object)this.custom);
            return ans;
        }
        return this.item.getDefaultInstance();
    }

    public GenericArrowItem getItem() {
        GenericArrowItem gen;
        Item item = this.item;
        return item instanceof GenericArrowItem ? (gen = (GenericArrowItem)item) : (GenericArrowItem)((Object)ArcheryItems.STARTER_ARROW.get());
    }
}

