/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.config.ArcheryStatConfig;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.content.item.IGeneralConfig;
import dev.xkmc.l2archery.content.stats.BowArrowStatType;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import dev.xkmc.l2core.util.ServerProxy;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;

public record ArrowConfig(GenericArrowItem id, int infLevel, List<BowArrowFeature> feature) implements IGeneralConfig
{
    private double getValue(BowArrowStatType type) {
        ArcheryStatConfig ans;
        RegistryAccess reg = ServerProxy.getRegistryAccess();
        if (reg != null && (ans = (ArcheryStatConfig)ArcheryRegister.ITEM_STAT.get(reg, (Holder)this.id.builtInRegistryHolder())) != null) {
            return ans.stats().getOrDefault((Object)type, type.getDefault());
        }
        return type.getDefault();
    }

    public PotionArrowFeature getEffects() {
        ArcheryStatConfig ans;
        RegistryAccess reg = ServerProxy.getRegistryAccess();
        if (reg != null && (ans = (ArcheryStatConfig)ArcheryRegister.ITEM_STAT.get(reg, (Holder)this.id.builtInRegistryHolder())) != null) {
            return ans.getEffects();
        }
        return PotionArrowFeature.NULL;
    }

    @Override
    public float damage() {
        return (float)this.getValue((BowArrowStatType)((Object)ArcheryRegister.DAMAGE.get()));
    }

    @Override
    public int punch() {
        return (int)this.getValue((BowArrowStatType)((Object)ArcheryRegister.PUNCH.get()));
    }

    public void addTooltip(List<Component> list) {
        LangData.STAT_DAMAGE.getWithSign(list, this.damage());
        LangData.STAT_PUNCH.getWithSign(list, this.punch());
        if (this.infLevel() == 2) {
            list.add((Component)LangData.FEATURE_INFINITY.get(new Object[0]));
        } else if (this.infLevel() == 1) {
            list.add((Component)LangData.FEATURE_INFINITY_ADV.get(new Object[0]));
        }
        PotionArrowFeature.addTooltip(this.getEffects().instances(), list);
    }
}

