/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.feature.types;

import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.feature.types.OnShootFeature;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.content.item.IGeneralConfig;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public class DefaultShootFeature
implements OnShootFeature {
    public static final DefaultShootFeature INSTANCE = new DefaultShootFeature();

    @Override
    public boolean onShoot(LivingEntity player, Consumer<Consumer<GenericArrowEntity>> consumer) {
        consumer.accept(entity -> {
            IGeneralConfig iGeneralConfig;
            Item arr = entity.data.arrow().item();
            if (arr instanceof GenericArrowItem) {
                GenericArrowItem gen = (GenericArrowItem)arr;
                iGeneralConfig = gen.getConfig();
            } else {
                iGeneralConfig = null;
            }
            IGeneralConfig config = iGeneralConfig;
            double damage = entity.getBaseDamage() + (double)entity.data.bow().getConfig().damage() + (double)(config == null ? 0.0f : config.damage());
            entity.setBaseDamage(Math.max(damage, 0.5));
        });
        return true;
    }

    @Override
    public void addTooltip(List<MutableComponent> list) {
    }
}

