/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.feature.core;

import dev.xkmc.l2archery.content.config.ArcheryEffectConfig;
import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.types.OnHitFeature;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import dev.xkmc.l2core.base.effects.EffectUtil;
import dev.xkmc.l2core.util.ServerProxy;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public record PotionArrowFeature(List<MobEffectInstance> instances) implements OnHitFeature
{
    public static final PotionArrowFeature NULL = new PotionArrowFeature(List.of());

    public static BowArrowFeature fromUpgradeConfig(Upgrade upgrade) {
        ArcheryEffectConfig ans;
        RegistryAccess reg = ServerProxy.getRegistryAccess();
        if (reg != null && (ans = (ArcheryEffectConfig)ArcheryRegister.UPGRADE_STAT.get(reg, ArcheryRegister.UPGRADE.get().wrapAsHolder((Object)upgrade))) != null) {
            return ans.getEffects();
        }
        return NULL;
    }

    @Override
    public void onHitLivingEntity(GenericArrowEntity arrow, LivingEntity target, EntityHitResult hit) {
    }

    @Override
    public void onHitBlock(GenericArrowEntity arrow, BlockHitResult result) {
    }

    @Override
    public void postHurtEntity(GenericArrowEntity arrow, LivingEntity target) {
        for (MobEffectInstance instance : this.instances) {
            EffectUtil.addEffect((LivingEntity)target, (MobEffectInstance)instance, (Entity)arrow.getOwner());
        }
    }

    @Override
    public void addTooltip(List<MutableComponent> list) {
    }

    public static void addTooltip(List<MobEffectInstance> instances, List<Component> list) {
        if (instances.size() > 5) {
            list.add((Component)LangData.STAT_EFFECT_TOO_MANY.get(instances.size()));
            return;
        }
        if (instances.size() > 0) {
            list.add((Component)LangData.STAT_EFFECT.get(new Object[0]));
        }
        for (MobEffectInstance eff : instances) {
            list.add((Component)PotionArrowFeature.getTooltip(eff));
        }
    }

    public static MutableComponent getTooltip(MobEffectInstance eff) {
        MutableComponent comp = Component.translatable((String)eff.getDescriptionId());
        MobEffect mobeffect = (MobEffect)eff.getEffect().value();
        if (eff.getAmplifier() > 0) {
            comp = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{comp, Component.translatable((String)("potion.potency." + eff.getAmplifier()))});
        }
        if (eff.getDuration() > 20) {
            comp = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{comp, MobEffectUtil.formatDuration((MobEffectInstance)eff, (float)1.0f, (float)20.0f)});
        }
        return comp.withStyle(mobeffect.getCategory().getTooltipFormatting());
    }

    @Override
    public boolean allowDuplicate() {
        return true;
    }
}

