/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.feature.bow;

import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.feature.bow.IGlowFeature;
import dev.xkmc.l2archery.content.feature.types.OnPullFeature;
import dev.xkmc.l2archery.content.feature.types.OnShootFeature;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import dev.xkmc.l2library.util.GenericItemStack;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public record EnderShootFeature(int range) implements OnShootFeature,
OnPullFeature,
IGlowFeature
{
    @Override
    public boolean onShoot(@Nullable LivingEntity player, Consumer<Consumer<GenericArrowEntity>> consumer) {
        if (player == null) {
            return false;
        }
        LivingEntity target = null;
        if (player instanceof Player) {
            Player pl = (Player)player;
            target = RayTraceUtil.serverGetTarget((Player)pl);
        } else if (player instanceof Mob) {
            Mob mob = (Mob)player;
            target = mob.getTarget();
        }
        if (target == null) {
            return false;
        }
        LivingEntity finalTarget = target;
        consumer.accept(arg_0 -> EnderShootFeature.lambda$onShoot$0((Entity)finalTarget, player, arg_0));
        return true;
    }

    @Override
    public void tickAim(LivingEntity player, GenericItemStack<GenericBowItem> bow) {
        if (player instanceof Player) {
            Player pl = (Player)player;
            RayTraceUtil.clientUpdateTarget((Player)pl, (double)this.range);
        }
    }

    @Override
    public void stopAim(LivingEntity player, GenericItemStack<GenericBowItem> bow) {
        if (player.level().isClientSide() && player instanceof LocalPlayer) {
            RayTraceUtil.TARGET.updateTarget(null);
        }
    }

    @Override
    public void addTooltip(List<MutableComponent> list) {
        list.add(LangData.FEATURE_ENDER_SHOOT.get(new Object[0]));
    }

    private static /* synthetic */ void lambda$onShoot$0(Entity finalTarget, LivingEntity player, GenericArrowEntity entity) {
        float w = finalTarget.getBbWidth();
        float h = finalTarget.getBbHeight();
        Vec3 dst = finalTarget.position().add(0.0, (double)(h / 2.0f), 0.0);
        double r = Math.sqrt(w * w * 2.0f + h * h) / 2.0;
        Vec3 src = player.getEyePosition().subtract(dst).normalize().scale(r + 1.0).add(dst);
        entity.setPos(src);
    }
}

