/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.feature.bow;

import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.feature.types.OnPullFeature;
import dev.xkmc.l2archery.content.feature.types.OnShootFeature;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2library.util.GenericItemStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record DoubleChargeFeature(double rate) implements OnShootFeature,
OnPullFeature
{
    @Override
    public boolean onShoot(LivingEntity player, Consumer<Consumer<GenericArrowEntity>> entity) {
        ItemStack stack = player.getUseItem();
        Item item = stack.getItem();
        if (!(item instanceof GenericBowItem)) {
            return true;
        }
        GenericBowItem bow = (GenericBowItem)item;
        int pullTime = bow.getUseDuration(stack, player) - player.getUseItemRemainingTicks();
        float power = bow.getRawPowerForTime(player, pullTime);
        if (power < 2.0f) {
            return true;
        }
        entity.accept(e -> e.setBaseDamage(e.getBaseDamage() * this.rate));
        return true;
    }

    @Override
    public void tickAim(LivingEntity player, GenericItemStack<GenericBowItem> bow) {
        int pullTime = ((GenericBowItem)bow.item()).getUseDuration(bow.stack(), player) - player.getUseItemRemainingTicks();
        float p0 = ((GenericBowItem)bow.item()).getRawPowerForTime(player, pullTime - 1);
        float p1 = ((GenericBowItem)bow.item()).getRawPowerForTime(player, pullTime);
        if (p0 < 2.0f && p1 >= 2.0f) {
            player.playSound(SoundEvents.AMETHYST_BLOCK_BREAK);
        }
    }

    @Override
    public void addTooltip(List<MutableComponent> list) {
        list.add(LangData.FEATURE_DOUBLE_CHARGE.get(Math.round(this.rate * 100.0) + "%"));
    }
}

