/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.feature.arrow;

import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.arrow.ExplosionBreakFeature;
import dev.xkmc.l2archery.content.feature.types.OnHitFeature;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2library.content.explosion.BaseExplosion;
import dev.xkmc.l2library.content.explosion.BaseExplosionContext;
import dev.xkmc.l2library.content.explosion.ExplosionHandler;
import dev.xkmc.l2library.content.explosion.ModExplosionContext;
import dev.xkmc.l2library.content.explosion.ParticleExplosionContext;
import dev.xkmc.l2library.content.explosion.VanillaExplosionContext;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public record ExplodeArrowFeature(float radius, boolean hurt, boolean breakBlock) implements OnHitFeature
{
    @Override
    public void onHitLivingEntity(GenericArrowEntity arrow, LivingEntity target, EntityHitResult hit) {
        this.explode(arrow, hit.getLocation().x(), hit.getLocation().y(), hit.getLocation().z());
        arrow.discard();
    }

    @Override
    public void onHitBlock(GenericArrowEntity arrow, BlockHitResult result) {
        this.explode(arrow, result.getLocation().x, result.getLocation().y, result.getLocation().z);
        arrow.discard();
    }

    private void explode(GenericArrowEntity arrow, double x, double y, double z) {
        boolean breaking = this.breakBlock();
        for (BowArrowFeature e : arrow.features.all()) {
            if (e != ExplosionBreakFeature.INS) continue;
            breaking = true;
            break;
        }
        BaseExplosionContext base = new BaseExplosionContext(arrow.level(), x, y, z, this.radius);
        Explosion.BlockInteraction type = breaking ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        VanillaExplosionContext mc = new VanillaExplosionContext((Entity)arrow, this.getSource(arrow), null, false, type);
        ModExplosionContext mod = entity -> this.onExplosionHurt(arrow, entity);
        ExplosionHandler.explode((BaseExplosion)new BaseExplosion(base, mc, mod, ParticleExplosionContext.of((float)this.radius)));
    }

    private boolean onExplosionHurt(GenericArrowEntity arrow, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            Entity entity = arrow.getOwner();
            if (entity instanceof Player) {
                Player pl = (Player)entity;
                le.setLastHurtByPlayer(pl);
            }
            arrow.doPostHurtEffects(le);
            return this.hurt;
        }
        if (target instanceof ItemEntity) {
            return false;
        }
        if (target instanceof ExperienceOrb) {
            return false;
        }
        if (target instanceof HangingEntity) {
            return false;
        }
        if (target instanceof Boat) {
            return false;
        }
        if (target instanceof AbstractMinecart) {
            return false;
        }
        return this.hurt;
    }

    @Nullable
    private DamageSource getSource(GenericArrowEntity arrow) {
        Entity ent = arrow.getOwner();
        if (ent instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)ent;
            return le.level().damageSources().explosion((Entity)arrow, ent);
        }
        return null;
    }

    @Override
    public void addTooltip(List<MutableComponent> list) {
        if (this.hurt && this.breakBlock) {
            list.add(LangData.FEATURE_EXPLOSION_ALL.get(Float.valueOf(this.radius)));
        }
        if (this.hurt && !this.breakBlock) {
            list.add(LangData.FEATURE_EXPLOSION_HURT.get(Float.valueOf(this.radius)));
        }
        if (!this.hurt && !this.breakBlock) {
            list.add(LangData.FEATURE_EXPLOSION_NONE.get(Float.valueOf(this.radius)));
        }
    }
}

