/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.entity;

import dev.xkmc.l2archery.content.entity.MobShootHelper;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.types.FlightControlFeature;
import dev.xkmc.l2archery.content.item.ArrowData;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.item.IGeneralConfig;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

@FieldsAreNonnullByDefault
public class GenericArrowEntity
extends AbstractArrow
implements IEntityWithComplexSpawn {
    public static final String TAG = "l2archery:rawShoot";
    public ArrowEntityData data = ArrowEntityData.DEFAULT;
    public FeatureList features = new FeatureList();

    public GenericArrowEntity(EntityType<GenericArrowEntity> type, Level level) {
        super(type, level);
    }

    public GenericArrowEntity(Level level, LivingEntity user, ArrowEntityData data, FeatureList features, ItemStack arrowStack, ItemStack bowStack) {
        super((EntityType)ArcheryRegister.ET_ARROW.get(), user, level, arrowStack, bowStack);
        this.data = data;
        this.features = features;
    }

    public void setBaseDamageFromMob(float v) {
    }

    protected void onHitEntity(EntityHitResult result) {
        if (!this.level().isClientSide()) {
            this.features.hit().forEach(e -> e.onHitEntity(this, result.getEntity(), result));
        }
        super.onHitEntity(result);
    }

    protected void doKnockback(LivingEntity target, DamageSource source) {
        float f;
        Level level;
        IGeneralConfig iGeneralConfig;
        ItemStack weapon = this.getWeaponItem();
        Item item = this.data.arrow().item();
        if (item instanceof GenericArrowItem) {
            GenericArrowItem gen = (GenericArrowItem)item;
            iGeneralConfig = gen.getConfig();
        } else {
            iGeneralConfig = null;
        }
        IGeneralConfig config = iGeneralConfig;
        int knock = this.data.bow().getConfig().punch() + (config == null ? 0 : config.punch());
        if (weapon != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback((ServerLevel)sl, (ItemStack)weapon, (Entity)target, (DamageSource)source, (float)knock);
        } else {
            f = knock;
        }
        double actual = f;
        if (actual > 0.0) {
            double d1 = Math.max(0.0, 1.0 - target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(actual * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                target.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    public void onHurtEntity(CreateSourceEvent ind) {
        if (!this.level().isClientSide()) {
            this.features.hit().forEach(e -> e.onHurtEntity(this, ind));
        }
    }

    public void onHurtModification(DamageData.Offence cache) {
        if (!this.level().isClientSide()) {
            this.features.hit().forEach(e -> e.onHurtModifier(this, cache));
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return ArcheryItems.STARTER_ARROW.asStack();
    }

    public void doPostHurtEffects(LivingEntity target) {
        if (!this.level().isClientSide()) {
            this.features.hit().forEach(e -> e.postHurtEntity(this, target));
        }
    }

    protected ItemStack getPickupItem() {
        return this.data.arrow.stack();
    }

    public void tick() {
        Vec3 velocity = this.getDeltaMovement();
        super.tick();
        if (this.hasImpulse) {
            velocity = this.getDeltaMovement();
        }
        FlightControlFeature flight = this.features.flight();
        flight.tickMotion(this, velocity);
        if (flight.life > 0 && this.tickCount > flight.life) {
            this.discard();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= this.features.flight().ground_life) {
            this.discard();
        }
    }

    public void shoot(double vx, double vy, double vz, float v, float variation) {
        Entity entity = this.getOwner();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!this.getTags().contains(TAG)) {
                this.addTag(TAG);
                LivingEntity target = mob.getTarget();
                if (target != null && target.isAlive()) {
                    float speed = this.data.bow().getConfig().speed() / 3.0f * v;
                    float gravity = this.features.flight().gravity;
                    MobShootHelper.shootAimHelper(target, (Projectile)this, speed, gravity);
                    return;
                }
            }
        }
        super.shoot(vx, vy, vz, v, variation);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.features.hit().forEach(e -> e.onHitBlock(this, result));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        Tag data_tag = new TagCodec((HolderLookup.Provider)this.level().registryAccess()).valueToTag(ArrowEntityData.class, (Object)this.data);
        if (data_tag != null) {
            tag.put("l2archery", data_tag);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("l2archery")) {
            CompoundTag data_tag = tag.getCompound("l2archery");
            ArrowEntityData temp = (ArrowEntityData)new TagCodec((HolderLookup.Provider)this.level().registryAccess()).valueFromTag((Tag)data_tag, ArrowEntityData.class);
            this.data = temp == null ? ArrowEntityData.DEFAULT : temp;
        }
        this.features = FeatureList.merge(this.data.bow.getFeatures(), this.data.arrow().getFeatures());
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        PacketCodec.to((RegistryFriendlyByteBuf)buffer, (Object)this.data);
        Entity owner = this.getOwner();
        buffer.writeInt(owner == null ? -1 : owner.getId());
        buffer.writeInt(this.getTags().size());
        for (String e : this.getTags()) {
            buffer.writeUtf(e);
        }
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        ArrowEntityData temp = (ArrowEntityData)PacketCodec.from((RegistryFriendlyByteBuf)additionalData, ArrowEntityData.class, null);
        this.data = temp == null ? ArrowEntityData.DEFAULT : temp;
        this.features = FeatureList.merge(this.data.bow.getFeatures(), this.data.arrow().getFeatures());
        this.features.shot().forEach(e -> e.onClientShoot(this));
        int id = additionalData.readInt();
        Entity owner = id == -1 ? null : this.level().getEntity(id);
        this.setOwner(owner);
        int size = additionalData.readInt();
        for (int i = 0; i < size; ++i) {
            this.addTag(additionalData.readUtf());
        }
    }

    public record ArrowEntityData(BowData bow, ArrowData arrow) {
        public static final ArrowEntityData DEFAULT = new ArrowEntityData(BowData.of((GenericBowItem)ArcheryItems.STARTER_BOW.get()), ArrowData.of((Item)ArcheryItems.STARTER_ARROW.get()));
    }
}

