/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.energy;

import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public interface IEnergyContainerItem {
    public ItemCapability<IEnergyStorage, @Nullable Void> getEnergyCapability();

    public int getExtract(ItemStack var1);

    public int getReceive(ItemStack var1);

    public int getMaxEnergyStored(ItemStack var1);

    default public int getSpace(ItemStack container) {
        return this.getMaxEnergyStored(container) - this.getEnergyStored(container);
    }

    public static int round(double d) {
        return (int)(d + 0.5);
    }

    default public int getScaledEnergyStored(ItemStack container, int scale) {
        return IEnergyContainerItem.round((double)this.getEnergyStored(container) * (double)scale / (double)this.getMaxEnergyStored(container));
    }

    default public int getEnergyStored(ItemStack container) {
        return Math.min((Integer)ArcheryItems.ENERGY.getOrDefault(container, (Object)0), this.getMaxEnergyStored(container));
    }

    default public void setEnergyStored(ItemStack container, int energy) {
        ArcheryItems.ENERGY.set(container, (Object)Mth.clamp((int)energy, (int)0, (int)this.getMaxEnergyStored(container)));
    }

    default public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = Math.min((Integer)ArcheryItems.ENERGY.getOrDefault(container, (Object)0), this.getMaxEnergyStored(container));
        int receive = Math.min(Math.min(maxReceive, this.getReceive(container)), this.getSpace(container));
        if (!simulate) {
            ArcheryItems.ENERGY.set(container, (Object)(stored += receive));
        }
        return receive;
    }

    default public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = Math.min((Integer)ArcheryItems.ENERGY.getOrDefault(container, (Object)0), this.getMaxEnergyStored(container));
        int extract = Math.min(Math.min(maxExtract, this.getExtract(container)), stored);
        if (!simulate) {
            ArcheryItems.ENERGY.set(container, (Object)(stored -= extract));
        }
        return extract;
    }
}

