/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.energy;

import dev.xkmc.l2archery.content.energy.IEnergyContainerItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyContainerItemWrapper
implements IEnergyStorage {
    protected final ItemStack container;
    protected final IEnergyContainerItem item;

    public EnergyContainerItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
        this.container = containerIn;
        this.item = itemIn;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return this.item.receiveEnergy(this.container, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        return this.item.extractEnergy(this.container, maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.item.getEnergyStored(this.container);
    }

    public int getMaxEnergyStored() {
        return this.item.getMaxEnergyStored(this.container);
    }

    public boolean canExtract() {
        return this.item.getExtract(this.container) > 0;
    }

    public boolean canReceive() {
        return this.item.getReceive(this.container) > 0;
    }
}

