/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.client;

import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.item.ArrowData;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.item.IBowConfig;
import dev.xkmc.l2archery.content.item.IGeneralConfig;
import dev.xkmc.l2archery.init.data.ArcheryConfig;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2itemselector.overlay.InfoSideBar;
import dev.xkmc.l2itemselector.overlay.SideBar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class BowInfoOverlay
extends InfoSideBar<BowStackSignature> {
    public BowInfoOverlay() {
        super(40.0f, 3.0f);
    }

    protected List<Component> getText() {
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        ItemStack bowStack = player.getMainHandItem();
        ItemStack arrowStack = player.getProjectile(bowStack);
        Item item = bowStack.getItem();
        if (!(item instanceof GenericBowItem)) {
            return List.of();
        }
        GenericBowItem bow = (GenericBowItem)item;
        ArrowData arrowData = bow.parseArrow(arrowStack);
        if (arrowData == null) {
            return List.of();
        }
        BowData bowData = BowData.of(bow, bowStack);
        FeatureList features = FeatureList.merge(bowData.getFeatures(), arrowData.getFeatures());
        ArrayList<Component> text = new ArrayList<Component>();
        BowInfoOverlay.addStat(text, bowData, arrowData.getItem().getConfig());
        features.addEffectsTooltip(text);
        features.addTooltip(text);
        return text;
    }

    private static void addStat(List<Component> list, BowData data, IGeneralConfig arrow) {
        int power;
        HolderLookup.RegistryLookup reg = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        IBowConfig bow = data.getConfig();
        double dmg = 2.0;
        ItemEnchantments map = data.ench();
        int n = power = reg == null ? 0 : map.getLevel((Holder)reg.getOrThrow(Enchantments.POWER));
        if (power > 0) {
            dmg += (double)power * 0.5 + 0.5;
        }
        int punch = reg == null ? 0 : map.getLevel((Holder)reg.getOrThrow(Enchantments.PUNCH));
        dmg += (double)(bow.damage() + arrow.damage());
        dmg *= (double)bow.speed();
        dmg = Math.ceil(dmg);
        String result = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(dmg) + "~" + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(dmg + dmg / 2.0 + 2.0);
        list.add((Component)LangData.STAT_DAMAGE.getWithColor(result, ChatFormatting.GREEN));
        list.add((Component)LangData.STAT_PUNCH.getWithColor(punch + bow.punch() + arrow.punch(), ChatFormatting.GREEN));
        list.add((Component)LangData.STAT_PULL_TIME.getWithColor((double)bow.pullTime() / 20.0, ChatFormatting.GREEN));
        list.add((Component)LangData.STAT_SPEED.getWithColor(Float.valueOf(bow.speed() * 20.0f), ChatFormatting.GREEN));
        list.add((Component)LangData.STAT_FOV.getWithColor(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(1.0f / (1.0f - bow.fov())), ChatFormatting.GREEN));
    }

    public BowStackSignature getSignature() {
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        ItemStack bowStack = player.getMainHandItem();
        ItemStack arrowStack = player.getProjectile(bowStack);
        return new BowStackSignature(player.getInventory().selected, arrowStack);
    }

    public boolean isScreenOn() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        ItemStack bowStack = player.getMainHandItem();
        if (!(bowStack.getItem() instanceof BowItem)) {
            return false;
        }
        ItemStack arrowStack = player.getProjectile(bowStack);
        if (!((Boolean)ArcheryConfig.CLIENT.showInfo.get()).booleanValue()) {
            return false;
        }
        Item item = bowStack.getItem();
        if (!(item instanceof GenericBowItem)) {
            return false;
        }
        GenericBowItem bow = (GenericBowItem)item;
        ArrowData arrowData = bow.parseArrow(arrowStack);
        return arrowData != null;
    }

    public record BowStackSignature(int sel, ItemStack bow) implements SideBar.Signature<BowStackSignature>
    {
        public boolean shouldRefreshIdle(SideBar<?> sideBar, @Nullable BowStackSignature old) {
            if (old == null) {
                return true;
            }
            if (this.sel != old.sel) {
                return true;
            }
            return !ItemStack.isSameItemSameComponents((ItemStack)this.bow, (ItemStack)old.bow);
        }
    }
}

