/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.neoforge.mixin;

import dev.obscuria.fragmentum.api.v1.server.FragmentumServerEvents;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer {
    @Shadow
    private MinecraftServer.ReloadableResources resources;

    @Inject(method={"reloadResources"}, at={@At(value="HEAD")})
    private void reloadResources_StartDataPackReload(Collection<String> selected, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        MinecraftServer server = (MinecraftServer)this;
        CloseableResourceManager manager = this.resources.resourceManager();
        FragmentumServerEvents.START_DATA_PACK_RELOAD.broadcast(handler -> handler.invoke(server, manager));
    }

    @Inject(method={"reloadResources"}, at={@At(value="TAIL")})
    private void reloadResources_EndDataPackReload(Collection<String> selected, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        MinecraftServer server = (MinecraftServer)this;
        CloseableResourceManager manager = this.resources.resourceManager();
        ((CompletableFuture)cir.getReturnValue()).handleAsync((value, throwable) -> {
            FragmentumServerEvents.END_DATA_PACK_RELOAD.broadcast(handler -> handler.invoke(server, manager, throwable == null));
            return value;
        }, (Executor)server);
    }

    @Inject(method={"saveEverything"}, at={@At(value="HEAD")})
    private void saveEverything_BeforeSave(boolean suppressLog, boolean flush, boolean forced, CallbackInfoReturnable<Boolean> info) {
        MinecraftServer server = (MinecraftServer)this;
        FragmentumServerEvents.BEFORE_SAVE.broadcast(handler -> handler.invoke(server, flush, forced));
    }

    @Inject(method={"saveEverything"}, at={@At(value="TAIL")})
    private void saveEverything_AfterSave(boolean suppressLog, boolean flush, boolean forced, CallbackInfoReturnable<Boolean> info) {
        MinecraftServer server = (MinecraftServer)this;
        FragmentumServerEvents.AFTER_SAVE.broadcast(handler -> handler.invoke(server, flush, forced));
    }
}

