/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.core.v1.common.text;

import com.google.common.collect.Lists;
import dev.obscuria.fragmentum.api.v1.common.text.TextWrapper;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class TextWrapperImpl
implements TextWrapper {
    private static final String BREAKER = "\n";
    private final String text;
    private final IntObjectMap<String> prefixByLine = new IntObjectHashMap();
    private final IntObjectMap<Style> styleByLine = new IntObjectHashMap();
    private Function<String, Component> fragment = Component::literal;
    private String defaultPrefix = "";
    private Style defaultStyle = Style.EMPTY;
    private int maxLength = 40;

    public TextWrapperImpl(Component component) {
        this(component.getString());
    }

    public TextWrapperImpl(String text) {
        this.text = text;
    }

    @Override
    public TextWrapper withMaxLength(int length) {
        this.maxLength = length;
        return this;
    }

    @Override
    public TextWrapper withPrefix(String prefix) {
        this.defaultPrefix = prefix;
        return this;
    }

    @Override
    public TextWrapper withLinePrefix(int index, String prefix) {
        this.prefixByLine.put(index, (Object)prefix);
        return this;
    }

    @Override
    public TextWrapper withStyle(Style style) {
        this.defaultStyle = style;
        return this;
    }

    @Override
    public TextWrapper withLineStyle(int index, Style style) {
        this.styleByLine.put(index, (Object)style);
        return this;
    }

    @Override
    public TextWrapper fragment(Function<String, Component> function) {
        this.fragment = function;
        return this;
    }

    @Override
    public List<? extends Component> build() {
        try {
            ArrayList result = Lists.newArrayList();
            ArrayList words = Lists.newArrayList(Arrays.stream(this.text.replace(BREAKER, " #$# ").split(" ")).filter(word -> !word.isBlank()).toList());
            while (!words.isEmpty()) {
                MutableComponent line = Component.literal((String)((String)this.prefixByLine.getOrDefault((Object)result.size(), (Object)this.defaultPrefix)));
                String firstWord = (String)words.removeFirst();
                if (firstWord.equals("#$#")) {
                    result.add(line.withStyle((Style)this.styleByLine.getOrDefault((Object)result.size(), (Object)this.defaultStyle)));
                    continue;
                }
                line.append(this.fragment.apply(firstWord));
                while (!words.isEmpty()) {
                    String word2 = (String)words.getFirst();
                    if (word2.equals("#$#")) {
                        words.removeFirst();
                        break;
                    }
                    Component finalWord = this.fragment.apply(word2);
                    if (TextWrapperImpl.getLength(line.getString() + " " + finalWord.getString()) > this.maxLength) break;
                    line.append(" ").append(finalWord);
                    words.removeFirst();
                }
                result.add(line.withStyle((Style)this.styleByLine.getOrDefault((Object)result.size(), (Object)this.defaultStyle)));
            }
            return result;
        }
        catch (Exception ignored) {
            return Lists.newArrayList();
        }
    }

    public static int getLength(String string) {
        return ChatFormatting.stripFormatting((String)string).length();
    }
}

