/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.api.v1.common.easing;

import dev.obscuria.fragmentum.api.v1.common.easing.EasingFunction;

final class EasingInternal {
    EasingInternal() {
    }

    public static EasingFunction linear() {
        return progress -> progress;
    }

    public static EasingFunction ceil() {
        return progress -> 1.0f;
    }

    public static EasingFunction floor() {
        return progress -> 0.0f;
    }

    public static EasingFunction easeInSine() {
        return progress -> 1.0f - (float)Math.cos((double)progress * Math.PI / 2.0);
    }

    public static EasingFunction easeInCircle() {
        return progress -> 1.0f - (float)Math.sqrt(1.0 - Math.pow(progress, 2.0));
    }

    public static EasingFunction easeInQuad() {
        return progress -> (float)Math.pow(progress, 2.0);
    }

    public static EasingFunction easeInCubic() {
        return progress -> (float)Math.pow(progress, 3.0);
    }

    public static EasingFunction easeInQuart() {
        return progress -> (float)Math.pow(progress, 4.0);
    }

    public static EasingFunction easeInQuint() {
        return progress -> (float)Math.pow(progress, 5.0);
    }

    public static EasingFunction easeInExpo() {
        return progress -> progress == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * progress - 10.0f);
    }

    public static EasingFunction easeInBack() {
        return progress -> 2.70158f * progress * progress * progress - 1.70158f * progress * progress;
    }

    public static EasingFunction easeInElastic() {
        return progress -> progress == 0.0f ? 0.0f : (progress == 1.0f ? 1.0f : (float)(-Math.pow(2.0, 10.0f * progress - 10.0f) * Math.sin((double)(progress * 10.0f - 10.75f) * 2.0943951023931953)));
    }

    public static EasingFunction easeInBounce() {
        return progress -> 1.0f - EasingInternal.easeOutBounce().compute(1.0f - progress);
    }

    public static EasingFunction easeOutSine() {
        return progress -> (float)Math.sin((double)progress * Math.PI / 2.0);
    }

    public static EasingFunction easeOutCircle() {
        return progress -> (float)Math.sqrt(1.0 - Math.pow(progress - 1.0f, 2.0));
    }

    public static EasingFunction easeOutQuad() {
        return progress -> 1.0f - (float)Math.pow(progress - 1.0f, 2.0);
    }

    public static EasingFunction easeOutCubic() {
        return progress -> 1.0f + (float)Math.pow(progress - 1.0f, 3.0);
    }

    public static EasingFunction easeOutQuart() {
        return progress -> 1.0f - (float)Math.pow(progress - 1.0f, 4.0);
    }

    public static EasingFunction easeOutQuint() {
        return progress -> 1.0f + (float)Math.pow(progress - 1.0f, 5.0);
    }

    public static EasingFunction easeOutExpo() {
        return progress -> progress == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * progress);
    }

    public static EasingFunction easeOutBack() {
        return progress -> 1.0f + 2.70158f * (float)Math.pow(progress - 1.0f, 3.0) + 1.70158f * (float)Math.pow(progress - 1.0f, 2.0);
    }

    public static EasingFunction easeOutElastic() {
        return progress -> progress == 0.0f ? 0.0f : (progress == 1.0f ? 1.0f : (float)(Math.pow(2.0, -10.0f * progress) * Math.sin((double)(progress * 10.0f - 0.75f) * 2.0943951023931953) + 1.0));
    }

    public static EasingFunction easeOutBounce() {
        return progress -> {
            float f1 = 7.5625f;
            float f2 = 2.75f;
            if (progress < 1.0f / f2) {
                return f1 * progress * progress;
            }
            if (progress < 2.0f / f2) {
                return f1 * (progress -= 1.5f / f2) * progress + 0.75f;
            }
            if ((double)progress < 2.5 / (double)f2) {
                return f1 * (progress -= 2.25f / f2) * progress + 0.9375f;
            }
            return f1 * (progress -= 2.625f / f2) * progress + 0.984375f;
        };
    }

    public static EasingFunction easeInOutSine() {
        return EasingInternal.easeInSine().merge(EasingInternal.easeOutSine());
    }

    public static EasingFunction easeInOutCircle() {
        return EasingInternal.easeInCircle().merge(EasingInternal.easeOutCircle());
    }

    public static EasingFunction easeInOutQuad() {
        return EasingInternal.easeInQuad().merge(EasingInternal.easeOutQuad());
    }

    public static EasingFunction easeInOutCubic() {
        return EasingInternal.easeInCubic().merge(EasingInternal.easeOutCubic());
    }

    public static EasingFunction easeInOutQuart() {
        return EasingInternal.easeInQuart().merge(EasingInternal.easeOutQuart());
    }

    public static EasingFunction easeInOutQuint() {
        return EasingInternal.easeInQuint().merge(EasingInternal.easeOutQuint());
    }

    public static EasingFunction easeInOutExpo() {
        return EasingInternal.easeInExpo().merge(EasingInternal.easeOutExpo());
    }

    public static EasingFunction easeInOutBack() {
        return EasingInternal.easeInBack().merge(EasingInternal.easeOutBack());
    }

    public static EasingFunction easeInOutElastic() {
        return EasingInternal.easeInElastic().merge(EasingInternal.easeOutElastic());
    }

    public static EasingFunction easeInOutBounce() {
        return EasingInternal.easeInBounce().merge(EasingInternal.easeOutBounce());
    }

    public static EasingFunction easeOutInSine() {
        return EasingInternal.easeOutSine().merge(EasingInternal.easeInSine());
    }

    public static EasingFunction easeOutInCircle() {
        return EasingInternal.easeOutCircle().merge(EasingInternal.easeInCircle());
    }

    public static EasingFunction easeOutInQuad() {
        return EasingInternal.easeOutQuad().merge(EasingInternal.easeInQuad());
    }

    public static EasingFunction easeOutInCubic() {
        return EasingInternal.easeOutCubic().merge(EasingInternal.easeInCubic());
    }

    public static EasingFunction easeOutInQuart() {
        return EasingInternal.easeOutQuart().merge(EasingInternal.easeInQuart());
    }

    public static EasingFunction easeOutInQuint() {
        return EasingInternal.easeOutQuint().merge(EasingInternal.easeInQuint());
    }

    public static EasingFunction easeOutInExpo() {
        return EasingInternal.easeOutExpo().merge(EasingInternal.easeInExpo());
    }

    public static EasingFunction easeOutInBack() {
        return EasingInternal.easeOutBack().merge(EasingInternal.easeInBack());
    }

    public static EasingFunction easeOutInElastic() {
        return EasingInternal.easeOutElastic().merge(EasingInternal.easeInElastic());
    }

    public static EasingFunction easeOutInBounce() {
        return EasingInternal.easeOutBounce().merge(EasingInternal.easeInBounce());
    }
}

