/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs;

import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AbstractAdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.MNode;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathResult;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.SurfaceType;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.AbstractPathJob;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class PathJobRandomPos
extends AbstractPathJob {
    private static final RandomSource random = RandomSource.createThreadSafe();
    protected final BlockPos destination;
    protected final int minDistFromStart;
    private final int maxDistToDest;

    public PathJobRandomPos(Level world, BlockPos start, int minDistFromStart, int range, LivingEntity entity) {
        super(world, start, start, range, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = range;
        Tuple<Direction, Direction> dir = PathJobRandomPos.getRandomDirectionTuple(random);
        this.destination = start.relative((Direction)dir.getA(), minDistFromStart).relative((Direction)dir.getB(), minDistFromStart);
    }

    public PathJobRandomPos(Level world, BlockPos start, int minDistFromStart, int searchRange, int maxDistToDest, LivingEntity entity, BlockPos dest) {
        super(world, start, dest, searchRange, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = maxDistToDest;
        this.destination = dest;
    }

    public PathJobRandomPos(Level world, BlockPos start, int minDistFromStart, int range, LivingEntity entity, BlockPos startRestriction, BlockPos endRestriction, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        super(world, start, startRestriction, endRestriction, range, false, new PathResult(), entity, restrictionType);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = range;
        Tuple<Direction, Direction> dir = PathJobRandomPos.getRandomDirectionTuple(random);
        this.destination = start.relative((Direction)dir.getA(), minDistFromStart).relative((Direction)dir.getB(), minDistFromStart);
    }

    public static Tuple<Direction, Direction> getRandomDirectionTuple(RandomSource random) {
        return new Tuple((Object)Direction.getRandom((RandomSource)random), (Object)Direction.getRandom((RandomSource)random));
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return Math.sqrt(this.destination.distSqr((Vec3i)new BlockPos(pos.getX(), this.destination.getY(), pos.getZ())));
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        return random.nextInt(10) == 0 && this.isInRestrictedArea(n.pos) && this.start.distSqr((Vec3i)n.pos) > (double)(this.minDistFromStart * this.minDistFromStart) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.getBlockState(n.pos.below()), n.pos.below()) == SurfaceType.WALKABLE && this.destination.distSqr((Vec3i)n.pos) < (double)(this.maxDistToDest * this.maxDistToDest);
    }

    @Override
    protected double getNodeResultScore(MNode n) {
        return this.destination.distSqr((Vec3i)n.pos);
    }

    public boolean posAndRangeMatch(int range, BlockPos pos) {
        return this.destination != null && range == this.maxDistToDest && this.destination.equals((Object)pos);
    }
}

