/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.neoforge.component;

import com.iafenvoy.uranus.neoforge.component.CapabilitySyncPayload;
import com.iafenvoy.uranus.neoforge.component.IAttachment;
import com.iafenvoy.uranus.neoforge.component.ITickableAttachment;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class CapabilitySyncHelper {
    public static final ResourceLocation CAPABILITY_SYNC = ResourceLocation.fromNamespaceAndPath((String)"uranus", (String)"capability_sync");
    private static final List<LivingCapabilityHolder<? extends IAttachment>> LIVINGS = new ArrayList<LivingCapabilityHolder<? extends IAttachment>>();
    private static final Map<UUID, List<ServerPlayer>> TRACKING_PLAYERS = new HashMap<UUID, List<ServerPlayer>>();

    public static <T extends IAttachment> void registerForLiving(ResourceLocation id, AttachmentType<T> capability) {
        LIVINGS.add(new LivingCapabilityHolder<T>(id, capability));
    }

    @Deprecated(forRemoval=true)
    public static <T extends IAttachment> void registerForLiving(AttachmentType<T> capability) {
    }

    @Deprecated(forRemoval=true)
    public static <T extends IAttachment> void registerForPlayer(ResourceLocation id, AttachmentType<T> capability) {
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TRACKING_PLAYERS.computeIfAbsent(target.getUUID(), uuid -> new LinkedList()).add(serverPlayer);
            for (LivingCapabilityHolder livingCapabilityHolder : LIVINGS) {
                IAttachment attachment = (IAttachment)target.getData(livingCapabilityHolder.attachmentType);
                CapabilitySyncHelper.syncToPlayers(target, livingCapabilityHolder.id, attachment.serializeNBT());
            }
        }
    }

    @SubscribeEvent
    public static void onStopTracking(PlayerEvent.StopTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            UUID uuid = event.getEntity().getUUID();
            List<ServerPlayer> players = TRACKING_PLAYERS.get(uuid);
            if (players == null) {
                return;
            }
            players.remove(serverPlayer);
            if (players.isEmpty()) {
                TRACKING_PLAYERS.remove(uuid);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        Level world = living.level();
        if (world instanceof ServerLevel) {
            for (LivingCapabilityHolder<? extends IAttachment> holder : LIVINGS) {
                IAttachment attachment = (IAttachment)living.getData(holder.attachmentType);
                if (!(attachment instanceof ITickableAttachment)) continue;
                ITickableAttachment tickable = (ITickableAttachment)attachment;
                tickable.tick();
                if (!tickable.isDirty()) continue;
                CapabilitySyncHelper.syncToPlayers((Entity)living, holder.id, attachment.serializeNBT());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        TRACKING_PLAYERS.remove(event.getEntity().getUUID());
    }

    private static void syncToPlayers(Entity entity, ResourceLocation id, CompoundTag compound) {
        for (ServerPlayer player : (List)TRACKING_PLAYERS.getOrDefault(entity.getUUID(), new LinkedList())) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CapabilitySyncPayload(id, entity.getId(), compound));
        }
    }

    static {
        if (Platform.getEnv() == Dist.DEDICATED_SERVER) {
            NetworkManager.registerS2CPayloadType(CapabilitySyncPayload.ID, CapabilitySyncPayload.CODEC);
        }
    }

    public static class LivingCapabilityHolder<T> {
        final ResourceLocation id;
        final AttachmentType<T> attachmentType;

        public LivingCapabilityHolder(ResourceLocation id, AttachmentType<T> attachmentType) {
            this.id = id;
            this.attachmentType = attachmentType;
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void init(FMLClientSetupEvent event) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CapabilitySyncPayload.ID, CapabilitySyncPayload.CODEC, (payload, ctx) -> ctx.queue(() -> {
                ClientLevel world = Minecraft.getInstance().level;
                if (world == null) {
                    return;
                }
                Entity entity = world.getEntity(payload.entityId());
                if (entity == null) {
                    return;
                }
                for (LivingCapabilityHolder<? extends IAttachment> holder : LIVINGS) {
                    if (!Objects.equals(holder.id, payload.id())) continue;
                    ((IAttachment)entity.getData(holder.attachmentType)).deserializeNBT(payload.compound());
                    break;
                }
            }));
        }
    }
}

