/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.thevortex.allthemodium.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.FakePlayer;

public class Allthemodium_Ore
extends RedStoneOreBlock {
    public Allthemodium_Ore() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS).lightLevel(state -> 15).strength(-1.0f, 1500.0f));
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity player) {
        if (player instanceof FakePlayer && state.getBlock() == ModRegistry.ALLTHEMODIUM_ORE.get()) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, player) && this.distanceTo(pos, player.blockPosition()) < 16.0;
    }

    private double distanceTo(BlockPos block, BlockPos player) {
        return Math.sqrt(Math.pow(block.getX() - player.getX(), 2.0) + Math.pow(block.getY() - player.getY(), 2.0) + Math.pow(block.getZ() - player.getZ(), 2.0));
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter getter, BlockPos blockPos) {
        BlockEntity blockEntity = getter.getBlockEntity(blockPos);
        if (this.canEntityDestroy(state, getter, blockPos, (Entity)player)) {
            int i = player.hasCorrectToolForDrops(state, player.level(), blockPos) ? 250 : 1500;
            return player.getDigSpeed(state, blockPos) / 2.0f / (float)i;
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void activate(BlockState p_196500_0_, Level worldIn, BlockPos p_196500_2_) {
        Allthemodium_Ore.spawnParticles(worldIn, p_196500_2_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Allthemodium_Ore.spawnParticles(worldIn, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnParticles(Level world, BlockPos worldIn) {
        RandomSource random = world.random;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = worldIn.offset(direction.getNormal());
            if (world.getBlockState(blockpos).isSolidRender((BlockGetter)world, blockpos)) continue;
            Direction.Axis direction$axis = direction.getAxis();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)random.nextFloat();
            double d = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)random.nextFloat();
        }
    }
}

