/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.network.packet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public class SendAbilityStorePacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<SendAbilityStorePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"send_ability_store"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SendAbilityStorePacket> CODEC = SendAbilityStorePacket.getCodec(SendAbilityStorePacket::new);
    @CodecField
    private int entityId;
    @CodecField
    private CompoundTag tag;
    @CodecField
    private int maxPlayerAbilities;

    public SendAbilityStorePacket() {
        super(TYPE);
    }

    public SendAbilityStorePacket(int entityId, CompoundTag tag) {
        this();
        this.entityId = entityId;
        this.tag = tag;
        this.maxPlayerAbilities = GeneralConfig.maxPlayerAbilities;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(net.minecraft.world.level.Level world, Player player) {
        try {
            Entity entity;
            if (world != null && (entity = world.getEntity(this.entityId)) != null) {
                EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getEntityAbilityStore(entity).ifPresent(abilityStore -> EverlastingAbilitiesInstance.MOD.getAbilityHelpers().deserialize(EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistry(world.registryAccess()), (IMutableAbilityStore)abilityStore, this.tag.get("contents")));
                EverlastingAbilitiesInstance.MOD.getAbilityHelpers().setMaxPlayerAbilitiesClient(this.maxPlayerAbilities);
            }
        }
        catch (IllegalArgumentException e) {
            EverlastingAbilitiesInstance.MOD.log(Level.ERROR, e.getMessage());
        }
    }

    public void actionServer(net.minecraft.world.level.Level world, ServerPlayer player) {
    }
}

