/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.helper;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityCondition;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IInitializableMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public interface IAbilityHelpers {
    public int getMaxPlayerAbilitiesClient();

    public void setMaxPlayerAbilitiesClient(int var1);

    public int[] getRarityColors();

    public Predicate<Holder<IAbilityType>> getPredicateAbilityEnabled();

    public Registry<IAbilityType> getRegistry(RegistryAccess var1);

    public HolderLookup.RegistryLookup<IAbilityType> getRegistryLookup(HolderLookup.Provider var1);

    public int getExperienceForLevel(int var1);

    public int getLevelForExperience(int var1);

    public Predicate<Holder<IAbilityType>> createRarityPredicate(Rarity var1);

    public List<Holder<IAbilityType>> getAbilityTypes(Registry<IAbilityType> var1, Predicate<Holder<IAbilityType>> var2);

    public List<Holder<IAbilityType>> getAbilityTypes(HolderLookup.Provider var1, Predicate<Holder<IAbilityType>> var2);

    public List<Holder<IAbilityType>> getAbilityTypesPlayerSpawn(Registry<IAbilityType> var1);

    public List<Holder<IAbilityType>> getAbilityTypesMobSpawn(Registry<IAbilityType> var1);

    public List<Holder<IAbilityType>> getAbilityTypesCrafting(Registry<IAbilityType> var1);

    public List<Holder<IAbilityType>> getAbilityTypesCrafting(HolderLookup.Provider var1);

    public List<Holder<IAbilityType>> getAbilityTypesLoot(Registry<IAbilityType> var1);

    public void onPlayerAbilityChanged(Player var1, IAbilityType var2, int var3, int var4);

    public int getMaxPlayerAbilities(Level var1);

    public Optional<IMutableAbilityStore> getEntityAbilityStore(Entity var1);

    public Optional<IMutableAbilityStore> getItemAbilityStore(ItemStack var1);

    public Ability addPlayerAbility(Player var1, Ability var2, boolean var3, boolean var4);

    public Ability removePlayerAbility(Player var1, Ability var2, boolean var3, boolean var4);

    public int getExperience(Ability var1);

    public void setPlayerAbilities(ServerPlayer var1, Map<Holder<IAbilityType>, Integer> var2);

    public boolean canInsert(Ability var1, IMutableAbilityStore var2);

    public boolean canExtract(Ability var1, IMutableAbilityStore var2);

    public boolean canInsertToPlayer(Ability var1, Player var2);

    public Ability insert(Ability var1, IMutableAbilityStore var2);

    public Ability extract(Ability var1, IMutableAbilityStore var2);

    public Optional<Holder<IAbilityType>> getRandomAbility(List<Holder<IAbilityType>> var1, RandomSource var2, Rarity var3);

    public Optional<Holder<IAbilityType>> getRandomAbilityUntilRarity(List<Holder<IAbilityType>> var1, RandomSource var2, Rarity var3, boolean var4);

    public Optional<ItemStack> getRandomTotem(List<Holder<IAbilityType>> var1, Rarity var2, RandomSource var3);

    public ItemStack getTotem(Ability var1);

    public Optional<Rarity> getRandomRarity(List<Holder<IAbilityType>> var1, RandomSource var2);

    public boolean hasRarityAbilities(List<Holder<IAbilityType>> var1, Rarity var2);

    public NavigableSet<Rarity> getValidAbilityRarities(List<Holder<IAbilityType>> var1);

    public Triple<Integer, Integer, Integer> getAverageRarityColor(IAbilityStore var1);

    public Supplier<Rarity> getSafeRarity(Supplier<Integer> var1);

    public Tag serialize(Registry<IAbilityType> var1, IMutableAbilityStore var2);

    public void deserialize(Registry<IAbilityType> var1, IMutableAbilityStore var2, Tag var3);

    public IAbilityCondition getAbilityConditionTrue();

    public IAbilityCondition getAbilityConditionFalse();

    public Codec<IAbilityCondition> getAbilityConditionCodec();

    public boolean hasPlayerStateLastFlight(Player var1);

    public boolean isPlayerStateLastFlight(Player var1);

    public void removePlayerStateLastFlight(Player var1);

    public void setPlayerStateLastFlight(Player var1, boolean var2);

    public void injectLootTotem(Consumer<ItemStack> var1, LootContext var2);

    public void initializeEntityAbilities(LivingEntity var1, IInitializableMutableAbilityStore var2);

    public void initializePlayerAbilitiesOnSpawn(Player var1);

    public boolean isFirstTotemSpawn(Player var1);

    public void onPlayerClone(Player var1, Player var2);

    public void onEntityDeath(Entity var1, DamageSource var2);

    public void onEntityTick(Entity var1);
}

