/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.gametest;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.helper.IAbilityHelpers;

public class GameTestsCommon {
    public static final String TEMPLATE_EMPTY = "cyclopscore:empty";
    public static final BlockPos POS = BlockPos.ZERO;

    @GameTest(template="cyclopscore:empty")
    public void testPlayerAbilityNotEnoughXp(GameTestHelper helper) {
        helper.succeedIf(() -> {
            Player player = helper.makeMockPlayer(GameType.SURVIVAL);
            player.totalExperience = 0;
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((Holder<IAbilityType>)abilityType, 3);
            helper.assertTrue(GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, false, true).isEmpty(), "Expected not to be addable in simulate-mode");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((Entity)player);
            helper.assertTrue(store.isPresent(), "Player has no ability store");
            helper.assertValueEqual((Object)store.get().getAbilities().size(), (Object)0, "Expect ability store of size 1");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testPlayerAbilityValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            Player player = helper.makeMockPlayer(GameType.SURVIVAL);
            player.totalExperience = 300;
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((Holder<IAbilityType>)abilityType, 3);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, false, true).isEmpty(), "Expected to be addable in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, true, true).isEmpty(), "Expected to be addable");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((Entity)player);
            helper.assertTrue(store.isPresent(), "Player has no ability store");
            helper.assertValueEqual((Object)store.get().getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.assertTrue(store.get().getAbility((Holder<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.assertValueEqual(store.get().getAbility((Holder<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.assertValueEqual((Object)store.get().getAbility((Holder<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
            helper.assertValueEqual((Object)player.totalExperience, (Object)0, "Expect XP to have been lowered");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testPlayerAbilityInvalidLevelTooHigh(GameTestHelper helper) {
        helper.succeedIf(() -> {
            Player player = helper.makeMockPlayer(GameType.SURVIVAL);
            player.totalExperience = 600;
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((Holder<IAbilityType>)abilityType, 6);
            helper.assertValueEqual((Object)GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, false, true).getLevel(), (Object)5, "Expected added ability to be of level 5 in simulate-mode");
            helper.assertValueEqual((Object)GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, true, true).getLevel(), (Object)5, "Expected added ability to be of level 5");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((Entity)player);
            helper.assertTrue(store.isPresent(), "Player has no ability store");
            helper.assertValueEqual((Object)store.get().getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.assertTrue(store.get().getAbility((Holder<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.assertValueEqual(store.get().getAbility((Holder<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.assertValueEqual((Object)store.get().getAbility((Holder<IAbilityType>)abilityType).getLevel(), (Object)5, "Expect ability level to be correct");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testPlayerAbilityMultipleSameValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            Player player = helper.makeMockPlayer(GameType.SURVIVAL);
            player.totalExperience = 300;
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability1 = new Ability((Holder<IAbilityType>)abilityType, 1);
            Ability ability2 = new Ability((Holder<IAbilityType>)abilityType, 1);
            Ability ability3 = new Ability((Holder<IAbilityType>)abilityType, 1);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, false, true).isEmpty(), "Expected to be addable (1) in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, true, true).isEmpty(), "Expected to be addable (1)");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be addable (2) in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be addable (2)");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability3, false, true).isEmpty(), "Expected to be addable (3) in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability3, true, true).isEmpty(), "Expected to be addable (3)");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((Entity)player);
            helper.assertTrue(store.isPresent(), "Player has no ability store");
            helper.assertValueEqual((Object)store.get().getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.assertTrue(store.get().getAbility((Holder<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.assertValueEqual(store.get().getAbility((Holder<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.assertValueEqual((Object)store.get().getAbility((Holder<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testPlayerAbilityMultipleDifferentValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            Player player = helper.makeMockPlayer(GameType.SURVIVAL);
            player.totalExperience = 1000;
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType1 = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Holder.Reference abilityType2 = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/darkness")));
            Ability ability1 = new Ability((Holder<IAbilityType>)abilityType1, 1);
            Ability ability2 = new Ability((Holder<IAbilityType>)abilityType2, 1);
            Ability ability3 = new Ability((Holder<IAbilityType>)abilityType1, 1);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, false, true).isEmpty(), "Expected to be addable (1) in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, true, true).isEmpty(), "Expected to be addable (1)");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be addable (2) in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be addable (2)");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability3, false, true).isEmpty(), "Expected to be addable (3) in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability3, true, true).isEmpty(), "Expected to be addable (3)");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((Entity)player);
            helper.assertTrue(store.isPresent(), "Player has no ability store");
            helper.assertValueEqual((Object)store.get().getAbilities().size(), (Object)2, "Expect ability store of size 2");
            helper.assertTrue(store.get().getAbility((Holder<IAbilityType>)abilityType1).getAbilityType() != null, "Expect ability type 1 to be contained");
            helper.assertValueEqual(store.get().getAbility((Holder<IAbilityType>)abilityType1).getAbilityTypeHolder(), (Object)abilityType1, "Expect ability type 1 to be correct");
            helper.assertValueEqual((Object)store.get().getAbility((Holder<IAbilityType>)abilityType1).getLevel(), (Object)2, "Expect ability level 1 to be correct");
            helper.assertTrue(store.get().getAbility((Holder<IAbilityType>)abilityType2).getAbilityType() != null, "Expect ability type 2 to be contained");
            helper.assertValueEqual(store.get().getAbility((Holder<IAbilityType>)abilityType2).getAbilityTypeHolder(), (Object)abilityType2, "Expect ability type 2 to be correct");
            helper.assertValueEqual((Object)store.get().getAbility((Holder<IAbilityType>)abilityType2).getLevel(), (Object)1, "Expect ability level 2 to be correct");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testPlayerRemoveAbilityValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            Player player = helper.makeMockPlayer(GameType.SURVIVAL);
            player.totalExperience = 300;
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((Holder<IAbilityType>)abilityType, 3);
            GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability, true, true);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability, false, true).isEmpty(), "Expected to be removable in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability, true, true).isEmpty(), "Expected to be removable");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((Entity)player);
            helper.assertTrue(store.isPresent(), "Player has no ability store");
            helper.assertValueEqual((Object)store.get().getAbilities().size(), (Object)0, "Expect ability store of size 0");
            helper.assertValueEqual((Object)player.totalExperience, (Object)300, "Expect XP to have been lowered again");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testPlayerRemoveAbilityMultipleSameValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            Player player = helper.makeMockPlayer(GameType.SURVIVAL);
            player.totalExperience = 300;
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability1 = new Ability((Holder<IAbilityType>)abilityType, 3);
            Ability ability2 = new Ability((Holder<IAbilityType>)abilityType, 1);
            GameTestsCommon.getAbilityHelpers().addPlayerAbility(player, ability1, true, true);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be removable in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be removable");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be removable in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be removable");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, false, true).isEmpty(), "Expected to be removable in simulate-mode");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().removePlayerAbility(player, ability2, true, true).isEmpty(), "Expected to be removable");
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((Entity)player);
            helper.assertTrue(store.isPresent(), "Player has no ability store");
            helper.assertValueEqual((Object)store.get().getAbilities().size(), (Object)0, "Expect ability store of size 0");
            helper.assertValueEqual((Object)player.totalExperience, (Object)300, "Expect XP to have been lowered again");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testPlayerClone(GameTestHelper helper) {
        helper.succeedIf(() -> {
            Player player1 = helper.makeMockPlayer(GameType.SURVIVAL);
            Player player2 = helper.makeMockPlayer(GameType.SURVIVAL);
            player1.totalExperience = 300;
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((Holder<IAbilityType>)abilityType, 3);
            GameTestsCommon.getAbilityHelpers().addPlayerAbility(player1, ability, true, true);
            GameTestsCommon.getAbilityHelpers().onPlayerClone(player1, player2);
            Optional<IMutableAbilityStore> store = GameTestsCommon.getAbilityHelpers().getEntityAbilityStore((Entity)player2);
            helper.assertTrue(store.isPresent(), "Player has no ability store");
            helper.assertValueEqual((Object)store.get().getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.assertTrue(store.get().getAbility((Holder<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.assertValueEqual(store.get().getAbility((Holder<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.assertValueEqual((Object)store.get().getAbility((Holder<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testItemAbilityValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ABILITY_BOTTLE);
            IMutableAbilityStore store = GameTestsCommon.getAbilityHelpers().getItemAbilityStore(itemStack).get();
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((Holder<IAbilityType>)abilityType, 3);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().insert(ability, store).isEmpty(), "Expected to be addable");
            helper.assertValueEqual((Object)store.getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.assertTrue(store.getAbility((Holder<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.assertValueEqual(store.getAbility((Holder<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.assertValueEqual((Object)store.getAbility((Holder<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testItemAbilityMultipleSameValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ABILITY_BOTTLE);
            IMutableAbilityStore store = GameTestsCommon.getAbilityHelpers().getItemAbilityStore(itemStack).get();
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((Holder<IAbilityType>)abilityType, 1);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().insert(ability, store).isEmpty(), "Expected to be addable");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().insert(ability, store).isEmpty(), "Expected to be addable");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().insert(ability, store).isEmpty(), "Expected to be addable");
            helper.assertValueEqual((Object)store.getAbilities().size(), (Object)1, "Expect ability store of size 1");
            helper.assertTrue(store.getAbility((Holder<IAbilityType>)abilityType).getAbilityType() != null, "Expect ability type to be contained");
            helper.assertValueEqual(store.getAbility((Holder<IAbilityType>)abilityType).getAbilityTypeHolder(), (Object)abilityType, "Expect ability type to be correct");
            helper.assertValueEqual((Object)store.getAbility((Holder<IAbilityType>)abilityType).getLevel(), (Object)3, "Expect ability level to be correct");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testItemAbilityMultipleDifferentValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ABILITY_BOTTLE);
            IMutableAbilityStore store = GameTestsCommon.getAbilityHelpers().getItemAbilityStore(itemStack).get();
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType1 = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Holder.Reference abilityType2 = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/darkness")));
            Ability ability1 = new Ability((Holder<IAbilityType>)abilityType1, 1);
            Ability ability2 = new Ability((Holder<IAbilityType>)abilityType2, 1);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().insert(ability1, store).isEmpty(), "Expected to be addable");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().insert(ability2, store).isEmpty(), "Expected to be addable");
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().insert(ability1, store).isEmpty(), "Expected to be addable");
            helper.assertValueEqual((Object)store.getAbilities().size(), (Object)2, "Expect ability store of size 2");
            helper.assertTrue(store.getAbility((Holder<IAbilityType>)abilityType1).getAbilityType() != null, "Expect ability type 1 to be contained");
            helper.assertValueEqual(store.getAbility((Holder<IAbilityType>)abilityType1).getAbilityTypeHolder(), (Object)abilityType1, "Expect ability type 1 to be correct");
            helper.assertValueEqual((Object)store.getAbility((Holder<IAbilityType>)abilityType1).getLevel(), (Object)2, "Expect ability level 1 to be correct");
            helper.assertTrue(store.getAbility((Holder<IAbilityType>)abilityType2).getAbilityType() != null, "Expect ability type 2 to be contained");
            helper.assertValueEqual(store.getAbility((Holder<IAbilityType>)abilityType2).getAbilityTypeHolder(), (Object)abilityType2, "Expect ability type 2 to be correct");
            helper.assertValueEqual((Object)store.getAbility((Holder<IAbilityType>)abilityType2).getLevel(), (Object)1, "Expect ability level 2 to be correct");
        });
    }

    @GameTest(template="cyclopscore:empty")
    public void testItemAbilityRemoveValid(GameTestHelper helper) {
        helper.succeedIf(() -> {
            ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ABILITY_BOTTLE);
            IMutableAbilityStore store = GameTestsCommon.getAbilityHelpers().getItemAbilityStore(itemStack).get();
            Registry<IAbilityType> registry = GameTestsCommon.getAbilityHelpers().getRegistry(helper.getLevel().registryAccess());
            Holder.Reference abilityType = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"everlastingabilities", (String)"effect/speed")));
            Ability ability = new Ability((Holder<IAbilityType>)abilityType, 3);
            GameTestsCommon.getAbilityHelpers().insert(ability, store);
            helper.assertTrue(!GameTestsCommon.getAbilityHelpers().extract(ability, store).isEmpty(), "Expected to be removable");
            helper.assertValueEqual((Object)store.getAbilities().size(), (Object)0, "Expect ability store of size 0");
        });
    }

    public static IAbilityHelpers getAbilityHelpers() {
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers();
    }
}

