/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import java.util.Collection;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.DefaultAbilityStore;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public class ItemDataMutableAbilityStore
implements IMutableAbilityStore {
    private final ItemStack itemStack;
    private final Runnable onModified;

    public ItemDataMutableAbilityStore(ItemStack itemStack, Runnable onModified) {
        this.itemStack = itemStack;
        this.onModified = onModified;
    }

    public ItemDataMutableAbilityStore(ItemStack itemStack) {
        this(itemStack, () -> {});
    }

    protected IMutableAbilityStore getInnerStore() {
        return new DefaultMutableAbilityStore((IAbilityStore)this.itemStack.get((DataComponentType)RegistryEntries.DATACOMPONENT_ABILITY_STORE.value()));
    }

    protected IMutableAbilityStore setInnerStore(IMutableAbilityStore store) {
        this.itemStack.set((DataComponentType)RegistryEntries.DATACOMPONENT_ABILITY_STORE.value(), (Object)new DefaultAbilityStore(store));
        this.onModified.run();
        return store;
    }

    @Override
    public Ability addAbility(Ability ability, boolean doAdd) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.addAbility(ability, doAdd);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public Ability removeAbility(Ability ability, boolean doRemove) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.removeAbility(ability, doRemove);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public void setAbilities(Map<Holder<IAbilityType>, Integer> abilityTypes) {
        IMutableAbilityStore store = this.getInnerStore();
        store.setAbilities(abilityTypes);
        this.setInnerStore(store);
    }

    @Override
    public boolean hasAbilityType(Holder<IAbilityType> abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.hasAbilityType(abilityType);
    }

    @Override
    public Collection<Holder<IAbilityType>> getAbilityTypes() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilityTypes();
    }

    @Override
    public Collection<Ability> getAbilities() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilities();
    }

    @Override
    public Map<Holder<IAbilityType>, Integer> getAbilitiesRaw() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilitiesRaw();
    }

    @Override
    public Ability getAbility(Holder<IAbilityType> abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbility(abilityType);
    }
}

