/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.DefaultAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public class DefaultMutableAbilityStore
extends DefaultAbilityStore
implements IMutableAbilityStore {
    public DefaultMutableAbilityStore() {
    }

    public DefaultMutableAbilityStore(Map<Holder<IAbilityType>, Integer> abilityTypes) {
        this.setAbilities(abilityTypes);
    }

    public DefaultMutableAbilityStore(@Nullable IAbilityStore abilityStore) {
        this((Map<Holder<IAbilityType>, Integer>)(abilityStore == null ? Maps.newHashMap() : abilityStore.getAbilitiesRaw()));
    }

    @Override
    public Ability addAbility(Ability ability, boolean doAdd) {
        Ability addedAbility;
        Holder<IAbilityType> abilityType = ability.getAbilityTypeHolder();
        int currentLevel = this.abilityTypes.containsKey(abilityType) ? (Integer)this.abilityTypes.get(abilityType) : 0;
        int maxLevel = ((IAbilityType)abilityType.value()).getMaxLevelInfinitySafe();
        int toAddLevel = ability.getLevel();
        int finalLevel = Math.min(currentLevel + toAddLevel, maxLevel);
        int addedLevel = finalLevel - currentLevel;
        Ability newAbility = new Ability(abilityType, finalLevel);
        Ability ability2 = addedAbility = addedLevel == 0 ? Ability.EMPTY : new Ability(abilityType, addedLevel);
        if (doAdd) {
            if (newAbility.getLevel() == 0) {
                this.abilityTypes.remove(newAbility.getAbilityTypeHolder());
            } else {
                this.abilityTypes.put(newAbility.getAbilityTypeHolder(), newAbility.getLevel());
            }
        }
        return addedAbility;
    }

    @Override
    public Ability removeAbility(Ability ability, boolean doRemove) {
        Ability removedAbility;
        Holder<IAbilityType> abilityType = ability.getAbilityTypeHolder();
        int currentLevel = this.abilityTypes.containsKey(abilityType) ? (Integer)this.abilityTypes.get(abilityType) : 0;
        int toRemoveLevel = ability.getLevel();
        int finalLevel = Math.max(currentLevel - toRemoveLevel, 0);
        int removedLevel = currentLevel - finalLevel;
        Ability newAbility = new Ability(abilityType, finalLevel);
        Ability ability2 = removedAbility = removedLevel == 0 ? Ability.EMPTY : new Ability(abilityType, removedLevel);
        if (doRemove) {
            if (newAbility.getLevel() == 0) {
                this.abilityTypes.remove(newAbility.getAbilityTypeHolder());
            } else {
                this.abilityTypes.put(newAbility.getAbilityTypeHolder(), newAbility.getLevel());
            }
        }
        return removedAbility;
    }
}

