/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IInitializableMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;

public class CompoundTagMutableAbilityStore
implements IMutableAbilityStore,
IInitializableMutableAbilityStore {
    private static final String NBT_STORE = "everlastingabilities:abilityStoreStack";
    private final Supplier<CompoundTag> tagSupplier;
    private final RegistryAccess registryAccess;

    public CompoundTagMutableAbilityStore(Supplier<CompoundTag> tagSupplier, RegistryAccess registryAccess) {
        this.tagSupplier = tagSupplier;
        this.registryAccess = registryAccess;
    }

    protected Registry<IAbilityType> getRegistry() {
        return EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getRegistry(this.registryAccess);
    }

    @Override
    public boolean isInitialized() {
        CompoundTag root = this.tagSupplier.get();
        return root.contains(NBT_STORE);
    }

    protected IMutableAbilityStore getInnerStore() {
        DefaultMutableAbilityStore store = new DefaultMutableAbilityStore();
        CompoundTag root = this.tagSupplier.get();
        if (!root.contains(NBT_STORE)) {
            root.put(NBT_STORE, (Tag)new ListTag());
        }
        Tag nbt = root.get(NBT_STORE);
        EverlastingAbilitiesInstance.MOD.getAbilityHelpers().deserialize(this.getRegistry(), store, nbt);
        return store;
    }

    protected IMutableAbilityStore setInnerStore(IMutableAbilityStore store) {
        CompoundTag root = this.tagSupplier.get();
        Tag nbt = EverlastingAbilitiesInstance.MOD.getAbilityHelpers().serialize(this.getRegistry(), store);
        root.put(NBT_STORE, nbt);
        return store;
    }

    @Override
    public Ability addAbility(Ability ability, boolean doAdd) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.addAbility(ability, doAdd);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public Ability removeAbility(Ability ability, boolean doRemove) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.removeAbility(ability, doRemove);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public void setAbilities(Map<Holder<IAbilityType>, Integer> abilityTypes) {
        IMutableAbilityStore store = this.getInnerStore();
        store.setAbilities(abilityTypes);
        this.setInnerStore(store);
    }

    @Override
    public boolean hasAbilityType(Holder<IAbilityType> abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.hasAbilityType(abilityType);
    }

    @Override
    public Collection<Holder<IAbilityType>> getAbilityTypes() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilityTypes();
    }

    @Override
    public Collection<Ability> getAbilities() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilities();
    }

    @Override
    public Map<Holder<IAbilityType>, Integer> getAbilitiesRaw() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilitiesRaw();
    }

    @Override
    public Ability getAbility(Holder<IAbilityType> abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbility(abilityType);
    }
}

