/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityCondition;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeSpecialPowerStare
extends AbilityTypeAdapter {
    private final boolean requireSneak;

    public AbilityTypeSpecialPowerStare(IAbilityCondition condition, String name, Rarity rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, boolean requireSneak) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.requireSneak = requireSneak;
    }

    @Override
    public MapCodec<? extends IAbilityType> codec() {
        return Objects.requireNonNull((MapCodec)RegistryEntries.ABILITYSERIALIZER_SPECIAL_POWER_STARE.value());
    }

    public boolean isRequireSneak() {
        return this.requireSneak;
    }

    @Override
    public void onTick(Player player, int level) {
        if (this.isRequireSneak() && !player.isCrouching()) {
            return;
        }
        Level world = player.level();
        if (!world.isClientSide && world.getGameTime() % (long)(IModHelpers.get().getMinecraftHelpers().getSecondInTicks() / 4) == 0L) {
            int range = level * 10;
            double eyeHeight = player.getEyeHeight();
            Vec3 lookVec = player.getLookAngle();
            Vec3 origin = new Vec3(player.getX(), player.getY() + eyeHeight, player.getZ());
            Vec3 direction = origin.add(lookVec.x * (double)range, lookVec.y * (double)range, lookVec.z * (double)range);
            List list = world.getEntities((Entity)player, player.getBoundingBox().expandTowards(lookVec.x * (double)range, lookVec.y * (double)range, lookVec.z * (double)range).inflate((double)range));
            for (Entity e : list) {
                double distance;
                if (!e.isPickable() || e instanceof TamableAnimal && ((TamableAnimal)e).getOwner() == player || player.isAlliedTo(e)) continue;
                Entity entity = null;
                float f10 = e.getPickRadius();
                AABB axisalignedbb = e.getBoundingBox().expandTowards((double)f10, (double)f10, (double)f10);
                Vec3 hitVec = axisalignedbb.clip(origin, direction).orElse(null);
                if (axisalignedbb.contains(origin)) {
                    entity = e;
                } else if (hitVec != null && ((distance = origin.distanceTo(hitVec)) < (double)range || (double)range == 0.0)) {
                    if (e == player.getVehicle()) {
                        if ((double)range == 0.0) {
                            entity = e;
                        }
                    } else {
                        entity = e;
                    }
                }
                if (entity == null) continue;
                double dx = entity.getX() - player.getX();
                double dy = entity.getY() - player.getY();
                double dz = entity.getZ() - player.getZ();
                double d = Mth.sqrt((float)((float)(dx * dx + dy * dy + dz * dz)));
                double m = 1.0 / (2.0 * Math.max(1.0, d));
                double strength = 3.0;
                entity.setDeltaMovement((dx *= m) * strength, (dy *= m) * strength, (dz *= m) * strength);
                break;
            }
        }
    }
}

