/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.everlastingabilities.EverlastingAbilitiesInstance;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityCondition;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeEffect
extends AbilityTypeAdapter {
    private final Target target;
    private final boolean targetsFriendlyMobs;
    private final double radiusFactor;
    private final String effectId;
    private final Holder<MobEffect> potion;
    private final int tickModulus;
    private final double amplifierFactor;
    private final boolean levelBasedDuration;
    private final double durationFactor;

    public AbilityTypeEffect(IAbilityCondition condition, String name, Rarity rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, Target target, boolean targetsFriendlyMobs, double radiusFactor, String effectId, int tickModulus, double amplifierFactor, boolean levelBasedDuration, double durationFactor) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.target = target;
        this.targetsFriendlyMobs = targetsFriendlyMobs;
        this.radiusFactor = radiusFactor;
        this.effectId = effectId;
        Optional potionOptional = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)effectId));
        if (potionOptional.isEmpty()) {
            EverlastingAbilitiesInstance.MOD.log(org.apache.logging.log4j.Level.INFO, "No potion effect was found with id: " + effectId + ". Marking as disabled.");
            this.setCondition(EverlastingAbilitiesInstance.MOD.getAbilityHelpers().getAbilityConditionFalse());
            this.potion = null;
        } else {
            this.potion = (Holder)potionOptional.get();
        }
        this.tickModulus = tickModulus;
        this.amplifierFactor = amplifierFactor;
        this.levelBasedDuration = levelBasedDuration;
        this.durationFactor = durationFactor;
    }

    public Target getTarget() {
        return this.target;
    }

    public boolean isTargetsFriendlyMobs() {
        return this.targetsFriendlyMobs;
    }

    public double getRadiusFactor() {
        return this.radiusFactor;
    }

    public String getEffectId() {
        return this.effectId;
    }

    public int getTickModulus() {
        return this.tickModulus;
    }

    public double getAmplifierFactor() {
        return this.amplifierFactor;
    }

    public boolean isLevelBasedDuration() {
        return this.levelBasedDuration;
    }

    public double getDurationFactor() {
        return this.durationFactor;
    }

    @Override
    public MapCodec<? extends IAbilityType> codec() {
        return Objects.requireNonNull((MapCodec)RegistryEntries.ABILITYSERIALIZER_EFFECT.value());
    }

    protected int getDuration(int tickModulus, int level) {
        if (this.isLevelBasedDuration()) {
            int maxLevel = this.getMaxLevel() == -1 ? 5 : this.getMaxLevel();
            return (int)((double)((float)IModHelpers.get().getMinecraftHelpers().getSecondInTicks() * ((float)level / (float)maxLevel * 20.0f)) * this.getDurationFactor());
        }
        return (int)((double)tickModulus * this.getDurationFactor());
    }

    protected int getTickModulus(int level) {
        return this.getTickModulus();
    }

    protected int getAmplifier(int level) {
        return (int)((double)(level - 1) * this.getAmplifierFactor());
    }

    @Override
    public void onTick(Player player, int level) {
        Level world = player.level();
        if (this.potion != null && !world.isClientSide && world.getGameTime() % (long)this.getTickModulus(level) == 0L) {
            switch (this.getTarget().ordinal()) {
                case 0: {
                    player.addEffect(new MobEffectInstance(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
                    break;
                }
                case 1: {
                    double radius = (double)level * this.getRadiusFactor();
                    List mobs = world.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(radius, radius, radius), EntitySelector.NO_SPECTATORS);
                    for (LivingEntity mob : mobs) {
                        if (mob == player || !this.targetsFriendlyMobs && AbilityTypeEffect.isFriendlyMob(mob, player)) continue;
                        mob.addEffect(new MobEffectInstance(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
                    }
                    break;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFriendlyMob(LivingEntity mob, Player player) {
        ResourceLocation resourceLocation = mob instanceof Player ? ResourceLocation.parse((String)"player") : BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType());
        String mobName = resourceLocation == null ? "null" : resourceLocation.toString();
        if (player.isAlliedTo((Entity)mob)) return true;
        if (mob instanceof TamableAnimal) {
            if (((TamableAnimal)mob).getOwner() == player) return true;
        }
        if (!GeneralConfig.friendlyMobs.stream().anyMatch(mobName::matches)) return false;
        return true;
    }

    public static enum Target {
        SELF,
        RADIUS;

    }
}

